/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveUV.cpp
 * @brief MGCurveUVTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenView.h"
#include "CurveCmd/CurveUV.h"
#include "Calc/curve.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


// MGCurveUVTool

MGCurveUVTool::MGCurveUVTool(fugenDoc* pDoc)
	 : MGSelectState(
		 pDoc,
		 ID_CURVE_CREATE_UV,
		 MGSelectState::SINGLE_SELECT,   // single-pick
		 mgAll_FSurface),
	   m_nIDS(1)
{
}

MGCommandBase* MGCurveUVTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGCurveUVTool(pDoc);
}

bool MGCurveUVTool::initiate_tool(){
	MGSelectState::initiate_tool();
	if(resetCurrentObjects(mgAll_FSurface)
		&& current_objects().size() == 1){
		// ȂvZ
		ASSERT(current_objects().front().top_object()->fsurface());
		if(!calculate(current_objects().front().top_object()->fsurface())){
			return OnCommandEnd(m_nIDS);
		}
		return OnCommandEnd(1);
	}else{
		clear_pick_object();
		prompt_message();
	}
	return false;
}

bool MGCurveUVTool::calculate(const MGFSurface* surf){
	ASSERT(surf);

	SetStatusMessage(IDS_PROMPT_COMPUTE);
	CWaitCursor hourglass;

	// 1. J[uvZ
	std::vector<UniqueCurve> c = surf->skeleton_at_knots();
	if(c.empty()){
		m_nIDS = IDS_FAIL_GENERATE_CURVE;
		return false;
	}

	// 2. hLgύX
	addUniqueGelsToCurrentGroup(c.begin(), c.end());
	return true;
}

bool MGCurveUVTool::OnSelected(
	fugenView* pView,
	MGPickObjects& curobj,
	MGPickObjects& remobj
	){
	ASSERT(curobj.size() == 1);
	ASSERT(dynamic_cast<MGFSurface*>(curobj.front().top_object()));

	if(!calculate(dynamic_cast<MGFSurface*>(curobj.front().top_object()))){
		return OnCommandEnd(m_nIDS);
	}
	return OnCommandEnd(1);
}

void MGCurveUVTool::prompt_message() const{
	SetStatusMessage(IDS_PROMPT_SURFACE);
}
