/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveSectionTool.h
 * @brief MGCurveSectionTool NX̃C^[tFCX
 */
#if !defined(AFX_SECTIONTOOL_H__4213DED0_3141_407D_AE81_600696E0F0C6__INCLUDED_)
#define AFX_SECTIONTOOL_H__4213DED0_3141_407D_AE81_600696E0F0C6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mg/Straight.h"
#include "Common/CommandStateOwner.h"
#include "Common/LocateState.h"
#include "Common/SelectState.h"

/// @class MGCurveSectionTool CurveSectionTool.h CurveCmd/CurveSectionTool.h
///
/// Creates sections.
/// Section curves are created by intersecting the selected objects 
/// with the section plane, which is perpendicular to the construction plane.
class MGCurveSectionTool : public MGCommandStateOwner{
public:
	explicit MGCurveSectionTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

private:
	bool calculate();

	MGPickObjects m_surf; ///< Object MGSurface to get section
	MGPickObjects m_shell; ///< Object MGShell to get section
	MGStraight m_line; ///< gluLookAt 
	UINT m_nIDS; ///< error message

	friend class MGCurveSectionToolSSurf;
	friend class MGCurveSectionToolIPoint;
};

//curve selection class.
class MGCurveSectionToolSSurf : public MGSelectState{
public:
	explicit MGCurveSectionToolSSurf(MGCommandStateOwner* owner);

	MGCurveSectionTool* state_owner(){
		return static_cast<MGCurveSectionTool*>(get_owner_command());
	}
	
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT, UINT, UINT);

private:
	void prompt_message() const;
};

//Weight data for the smoothing input class.
class MGCurveSectionToolIPoint : public MGLocateState{
public:
	explicit MGCurveSectionToolIPoint(MGCommandStateOwner* owner);
	MGCurveSectionTool* state_owner(){
		return static_cast<MGCurveSectionTool*>(get_owner_command());
	}

	virtual bool OnLocated(const MGLocateInfo& linfo);

private:
	void prompt_message() const;
};

#endif // !defined(AFX_SECTIONTOOL_H__4213DED0_3141_407D_AE81_600696E0F0C6__INCLUDED_)
