/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#if !defined(AFX_CURVEREBUILDDLG_H__363A8633_7E02_4BA2_A1CD_F8989347E33F__INCLUDED_)
#define AFX_CURVEREBUILDDLG_H__363A8633_7E02_4BA2_A1CD_F8989347E33F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "resource.h"
#include "EditCmd/EditRebuildTool.h"

/////////////////////////////////////////////////////////////////////////////
// CCurveRebuildDlg _CAO

class CCurveRebuildDlg : public CDialog{
// RXgNV
public:
	CCurveRebuildDlg(MGRebuildTool* pParent);
	void enable_orderEdit(BOOL active);
	void enable_SEParamRange(BOOL active);
	void get_param(
		int& splineApprox,
		int& reparameterize,
		double& tolerance,
		size_t& ordr,
		double range[2]
	)const;

// _CAO f[^
	//{{AFX_DATA(CCurveRebuildDlg)
	enum { IDD = IDD_CURVE_REBUILD_DLG };
	//}}AFX_DATA

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B
	//{{AFX_VIRTUAL(CCurveRebuildDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	//}}AFX_VIRTUAL


// Cve[V
protected:

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CCurveRebuildDlg)
	virtual BOOL OnInitDialog();
	virtual void OnBnClickedRadio0();
	virtual void OnBnClickedRadio1();
	virtual void OnBnClickedRadio2();
	virtual void OnBnClickedCurveRebuildSapprox();
	virtual void OnBnClickedRadio3();
	virtual void OnBnClickedCheck2();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	MGRebuildTool* m_parentCMD;

public:

	// Indicates how spline approximation of the curve be done.
	// =0: no spline approximation
	// =1: non-rational spline approximation if this is rational spline,
	//     otherwise no approximation, stay type-unchanged.
	// =2: approximate this curve by non-rational spline.
	int m_splineApprox;
	BOOL m_splineApproxCheck;

	// 0: non reparameterize, 1:[0,1] reparameterize, 2: Chord length reparameterize
	// 3: specify range.
	int m_reparameterize;

	BOOL m_nonRational2;

	// Tolerance allowed for the approximation of the object, MGTolerance::line_error is default.
	double m_tolerance2;

	// order in case of spline approximation, valid only when m_splineApprox=1, or 2.
	size_t m_order;

	// When m_reparameterize=3(Specify start and end parameter), this is active,
	// and is start adn end param.
	double m_SParam;
	double m_EParam;

public:
	afx_msg void OnDeltaposCurveRebuildSpinOrder(NMHDR *pNMHDR, LRESULT *pResult);
//	afx_msg void OnBnClickedRadio0();
//	afx_msg void OnBnClickedRadio1();
//	afx_msg void OnBnClickedRadio2();
//	afx_msg void OnBnClickedCurveRebuildSapprox();
//	afx_msg void OnBnClickedRadio3();
//	afx_msg void OnBnClickedCheck2();
	BOOL m_check2;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_CURVEREBUILDDLG_H__363A8633_7E02_4BA2_A1CD_F8989347E33F__INCLUDED_)
