/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurvePullProject.h
 * @brief MGCurvePullProjectTool NX̃C^[tFCX
 */
#if !defined(AFX_PULLPROJECT_H__1DB617BA_5921_4F29_9EDA_06BD9A9FCB04__INCLUDED_)
#define AFX_PULLPROJECT_H__1DB617BA_5921_4F29_9EDA_06BD9A9FCB04__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

// class MGCurvePullProjectTool
//
// Pulls a curve back to a surface/face/shell.
class MGCurvePullProjectTool : public MGCommandStateOwner{
public:
	explicit MGCurvePullProjectTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

private:
	bool calculate();

	// eACe
	MGPickObjects m_point;
	MGPickObjects m_curve;
	MGPickObjects m_surf;
	MGPickObjects m_shell;

	UINT m_nIDS; ///< error message

	friend class MGCurvePullProjectSCurve;
	friend class MGCurvePullProjectSSurf;
};

// class MGCurvePullProjectSCurve
// 
// ȐłȂ_eł悤ɎȂB
class MGCurvePullProjectSCurve : public MGSelectState{
public:
	MGCurvePullProjectSCurve(MGCommandStateOwner* owner);
	MGCurvePullProjectTool* state_owner(){
		return static_cast<MGCurvePullProjectTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
};

// class MGCurvePullProjectSSurf
// 
// e̓IƂȂIuWFNgIB
class MGCurvePullProjectSSurf : public MGSelectState{
public:
	MGCurvePullProjectSSurf(MGCommandStateOwner* owner);
	MGCurvePullProjectTool* state_owner(){
		return static_cast<MGCurvePullProjectTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
};

#endif // !defined(AFX_PULLPROJECT_H__1DB617BA_5921_4F29_9EDA_06BD9A9FCB04__INCLUDED_)
