/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveProjectionTool.h
 * @brief MGCurveProjectionTool NX̃C^[tFCX
 */
#if !defined(AFX_PROJECTIONTOOL_H__D37457F2_1E09_4F3D_A5D6_CED7CB06FAD9__INCLUDED_)
#define AFX_PROJECTIONTOOL_H__D37457F2_1E09_4F3D_A5D6_CED7CB06FAD9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"

/// @class MGCurveProjectionTool CurveProjectionTool.h CurveCmd/CurveProjectionTool.h
///
/// Projects a curve to a surface/face/shell.
/// The curves are projected vertical to the construction plane 
/// when the curve selection is completed.
/// Make sure the correct construction plane is active when you select the curves.
class MGCurveProjectionTool : public MGCommandStateOwner{
public:
	explicit MGCurveProjectionTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

private:
	bool calculate();
	void import_selected();

	// eACe
	MGPickObjects m_point;
	MGPickObjects m_curve;
	MGPickObjects m_surf;
	MGPickObjects m_shell;

	MGVector m_dir; ///< e
	UINT m_nIDS; ///< error message

	friend class MGProjectionSCurve;
	friend class MGProjectionSSurf;
};

/// @class MGProjectionSCurve
/// 
/// ȐłȂ_eł悤ɎȂB
class MGProjectionSCurve : public MGSelectState{
public:
	MGProjectionSCurve(MGCommandStateOwner* owner);
	MGCurveProjectionTool* state_owner(){
		return static_cast<MGCurveProjectionTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
};

/// @class MGProjectionSSurf
/// 
/// e̓IƂȂIuWFNgIB
class MGProjectionSSurf : public MGSelectState{
public:
	MGProjectionSSurf(MGCommandStateOwner* owner);
	MGCurveProjectionTool* state_owner(){
		return static_cast<MGCurveProjectionTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
};

#endif // !defined(AFX_PROJECTIONTOOL_H__D37457F2_1E09_4F3D_A5D6_CED7CB06FAD9__INCLUDED_)
