/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveOffsetTool.h
 * @brief MGCurveOffsetTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVEOFFSETTOOL_H__CB92E09A_2930_42FE_B34A_FC696410C3EC__INCLUDED_)
#define AFX_CURVEOFFSETTOOL_H__CB92E09A_2930_42FE_B34A_FC696410C3EC__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGCurveOffsetTool CurveOffsetTool.h CurveCmd/CurveOffsetTool.h
///
/// Offsets a curve.
class MGCurveOffsetTool : public MGSelectState{
public:
	explicit MGCurveOffsetTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView*, UINT, UINT, UINT);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

	virtual bool OnCommandEnd(
		UINT nIDS,
		bool erase_temporary_display=true);


private:
	bool calculate();
	bool input_param();
	void prompt_message() const;
	void UpdatePreview();

	double m_dOffset; ///< ItZbg鋗
	MGPickObjects m_curve; ///< ItZbg邷ׂĂ̋Ȑ
	std::vector<UniqueCurve> m_preview; ///< A^Cvr[p
};

#endif // !defined(AFX_CURVEOFFSETTOOL_H__CB92E09A_2930_42FE_B34A_FC696410C3EC__INCLUDED_)
