/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveNegateTool.h
 * @brief MGCurveNegateTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVENEGATETOOL_H__C06ED9F8_6CC5_43C7_B4AF_673FC167F54C__INCLUDED_)
#define AFX_CURVENEGATETOOL_H__C06ED9F8_6CC5_43C7_B4AF_673FC167F54C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGCurveNegateTool CurveNegateTool.h CurveCmd/CurveNegateTool.h
///
/// Changes direction of a curve.
class MGCurveNegateTool : public MGSelectState{
public:
	explicit MGCurveNegateTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);

private:
	bool calculate();
};

#endif // !defined(AFX_CURVENEGATETOOL_H__C06ED9F8_6CC5_43C7_B4AF_673FC167F54C__INCLUDED_)
