/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveNegateTool.cpp
 * @brief MGCurveNegateTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "CurveCmd/CurveNegateTool.h"

#include "Calc/mgcalc.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCurveNegateTool

MGCurveNegateTool::MGCurveNegateTool(fugenDoc* pDoc)
	 : MGSelectState(
		 pDoc,
		 ID_CURVE_NEGATE,
		 MGSelectState::MULTIPLE_SELECT,
		 mgAll_Curve)
{}

MGCommandBase* MGCurveNegateTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGCurveNegateTool(pDoc);
}

bool MGCurveNegateTool::initiate_tool(){
	MGSelectState::initiate_tool();
	const MGPickObjects& curobj = current_objects();
	resetCurrentObjects(mgAll_Curve);

	if(!curobj.empty()){
		// łɌvZ\
		if(!calculate()){
			OnCommandEnd(2);
			return false;
		}
		return OnCommandEnd(1);
	}
	SetStatusMessage(IDS_PROMPT_CURVE);
	return false;
}

bool MGCurveNegateTool::calculate(){
	// vZJn
	SetStatusMessage(IDS_PROMPT_COMPUTE);
	CWaitCursor sandglass;

	fugenDoc& doc = *document();
	const MGPickObjects& objs = current_objects();
	MGGelPositions org, rpl;
	MGPickObjects::const_iterator first = objs.begin(), last = objs.end();
	for(; first != last; ++first){
		const MGCurve* curve = dynamic_cast<const MGCurve*>((*first)->top_object());
		ASSERT(curve);

		// GelReplace Ȃ̂ŃRs[IuWFNgA
		// ό`̂ƌ
		org.push_back(**first);
		MGCurve* c=curve->clone();
		c->negate();
		rpl.push_back(make_gelpos(c, (*first)->bottom_group()));
	}

	// hLgύX
	replace(org,rpl);
	return true;
}

bool MGCurveNegateTool::OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags){
	switch(nChar){
	case VK_RETURN:{
			if(resetCurrentObjects(mgAll_Curve)){
				if(!calculate()){
					// failed
					return OnCommandEnd(2);
				}
				return OnCommandEnd(1);
			}
		}
		return false;
	default:
		return MGSelectState::OnKeyDown(pView, nChar, nRepCnt, nFlags);
	}
}
