/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveMoveTool.h
 * @brief MGCurveMoveTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVEMOVETOOL_H__8C4B18AE_91C1_4192_8A71_763085E71821__INCLUDED_)
#define AFX_CURVEMOVETOOL_H__8C4B18AE_91C1_4192_8A71_763085E71821__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mg/LBRep.h"
#include "Common/LocateState.h"

/// @class MGCurveMoveTool CurveMoveTool.h CurveCmd/CurveMoveTool.h
///
/// Modifies a curve as rubber.
class MGCurveMoveTool : public MGLocateState{
public:
	explicit MGCurveMoveTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	std::unique_ptr<MGCurve> make_model(const MGPosition& dest);
	void prompt_message() const;

	MGCurve* m_originalCurve;///Target curve to move, MGLBRep or MGStraight.
				///When m_originalCurve is straight, m_straight is set and m_lbrep=0.
				///When m_originalCurve is LBRep, m_straight=0 and m_lbrep is set.
	MGStraight* m_straight; ///< replace ̌()
	MGLBRep* m_lbrep; ///< replace ̌
	double m_param; ///< m_lbrep sbNʒũp[^
};

#endif // !defined(AFX_CURVEMOVETOOL_H__8C4B18AE_91C1_4192_8A71_763085E71821__INCLUDED_)
