/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveIsectTool.h
 * @brief MGCurveIsectTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVEISECTTOOL_H__4739CCC1_2456_4240_BC4D_961654A6CD43__INCLUDED_)
#define AFX_CURVEISECTTOOL_H__4739CCC1_2456_4240_BC4D_961654A6CD43__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

// class MGCurveIsectTool
//
// Intersects surfaces and/or faces.
// Creates curve or point objects at the intersection.
class MGCurveIsectTool : public MGSelectState{
public:
	explicit MGCurveIsectTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);

private:
	bool calculate();
	void prompt_message() const;

	UINT m_nIDS;  // R}hs̃vvg ID
};

#endif // !defined(AFX_CURVEISECTTOOL_H__4739CCC1_2456_4240_BC4D_961654A6CD43__INCLUDED_)
