/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CurveFillet.h
 * @brief MGCurveFilletTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVEFILLET_H__4D46A5A2_1A5F_4CA0_8FD1_BBF489BA35CD__INCLUDED_)
#define AFX_CURVEFILLET_H__4D46A5A2_1A5F_4CA0_8FD1_BBF489BA35CD__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGCurveFilletTool CurveFillet.h CurveCmd/CurveFillet.h
/// 
/// Fillets two curves.
class MGCurveFilletTool : public MGSelectState{
public:
	explicit MGCurveFilletTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView*, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnSelected(fugenView* pView, MGPickObjects&, MGPickObjects&);
	
private:
	bool calculate();
	bool input_param();
	void prompt_message() const;

	MGPickObject m_curve1; ///< ΏۋȐ1
	MGPickObject m_curve2; ///< ΏۋȐ2
	double m_dRadius; // tBbga{>=0}
	UINT m_nIDS; ///< G[bZ[W
	bool m_bJoin; ///< Ȑڍ邩ǂ
	bool m_bTrim; ///< ̋Ȑg(orvZ̈ꎞg)ǂ
};

#endif // !defined(AFX_CURVEFILLET_H__4D46A5A2_1A5F_4CA0_8FD1_BBF489BA35CD__INCLUDED_)
