/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveExtractWire.h
 * @brief MGCurveExtractWireTool NX̃C^[tFCX
 */
#if !defined(AFX_CURVEEXTRACTWIRE_H__0860BDCE_1DD6_4EB9_B65B_B2238E317AA9__INCLUDED_)
#define AFX_CURVEEXTRACTWIRE_H__0860BDCE_1DD6_4EB9_B65B_B2238E317AA9__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGCurveExtractWireTool CurveExtractWire.h CurveCmd/CurveExtractWire.h
///
/// Extracts the wireframe of surfaces or faces.
/// The isoparametric curves and edge curves are duplicated as separate curves.
///
/// bXPgłB
class MGCurveExtractWireTool : public MGSelectState{
public:
	explicit MGCurveExtractWireTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);

private:
	bool calculate();
	void prompt_message() const;

	MGPickObjects m_surf; ///< IꂽȖ
	UINT m_nIDS; ///< error message
};

#endif // !defined(AFX_CURVEEXTRACTWIRE_H__0860BDCE_1DD6_4EB9_B65B_B2238E317AA9__INCLUDED_)
