/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveDuplicateEdge.h
 * @brief MGCurveDuplicateEdgeTool NX̃C^[tFCX
 */
#if !defined(AFX_DUPLICATEEDGE_H__BB67E4FE_BDAA_42EF_BAE7_1C7A977A477C__INCLUDED_)
#define AFX_DUPLICATEEDGE_H__BB67E4FE_BDAA_42EF_BAE7_1C7A977A477C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGCurveDuplicateEdgeTool CurveDuplicateEdge.h CurveCmd/CurveDuplicateEdge.h
///
/// Duplicates an edge of a surface/face.
class MGCurveDuplicateEdgeTool : public MGSelectState{
public:
	explicit MGCurveDuplicateEdgeTool(fugenDoc*);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
	);
	
private:
	void calculate();
};

#endif // !defined(AFX_DUPLICATEEDGE_H__BB67E4FE_BDAA_42EF_BAE7_1C7A977A477C__INCLUDED_)
