/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveDuplicateEdge.cpp
 * @brief MGCurveDuplicateEdgeTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "CurveCmd/CurveDuplicateEdge.h"
#include "mg/PickObjectFB.h"
#include "mg/PickObjectSB.h"
#include "topo/Edge.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCurveDuplicateEdgeTool

MGCurveDuplicateEdgeTool::MGCurveDuplicateEdgeTool(fugenDoc* pDoc)
	 : MGSelectState(
		 pDoc,
		 ID_CURVE_EXTRACT_EDGE,
		 MGSelectState::SINGLE_SELECT, // single pick
		 mgAll_2Manifold,
		 MGSelectState::BOUNDARY_SELECT)  // edge pick
{
}

MGCommandBase* MGCurveDuplicateEdgeTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGCurveDuplicateEdgeTool(pDoc);
}

bool MGCurveDuplicateEdgeTool::initiate_tool(){
	MGSelectState::initiate_tool();
	clear_pick_object(); // IɃI[NA
	// ŏ̃bZ[W
	SetStatusMessage(IDS_PROMPT_EDGE);
	return false;
}

bool MGCurveDuplicateEdgeTool::OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
){
	ASSERT(objs.size() == 1); // single-pick
	MGCurve* result = 0;
	if(MGPickObjectSB* boundary = dynamic_cast<MGPickObjectSB*>(&objs.front())){
		// surface perimeter
		const MGSurface* surf = boundary->surface();
		//ASSERT(surf);
		ASSERT(dynamic_cast<const MGPlane*>(surf) == 0);
		result = surf->perimeter_curve(boundary->perimeter());
	}else if(MGPickObjectFB* boundary = dynamic_cast<MGPickObjectFB*>(&objs.front())){
		// face edge
		MGEdge* edge = boundary->edge()->binder_edge();
		ASSERT(edge);

		result = edge->curve_limitted();
		ASSERT(result);
	}else{
		// R}h͂܂IȂ
		return false;
	}
	
	ASSERT(result);
	add_object_to_current_group(result);

	// R}hI
	return OnCommandEnd(1);
}
