/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CurveContourTool.h
 * @brief MGCurveContourTool NX̃C^[tFCX
 */
#if !defined(AFX_CONTOURTOOL_H__0D535F9E_AF4B_4CB6_B24E_E6C35165B563__INCLUDED_)
#define AFX_CONTOURTOOL_H__0D535F9E_AF4B_4CB6_B24E_E6C35165B563__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"
#include "ContourDlg.h"

/// @class MGCurveContourTool CurveCurveContourTool.h CurveCmd/CurveCurveContourTool.h
///
/// Creates contour curves of surface objects.
class MGCurveContourTool : public MGSelectState{
public:
	explicit MGCurveContourTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	
private:
	bool calculate();
	bool input_param();
	void prompt_message() const;
	
	// R}h̃p[^擾邽߂̃_CAO{bNX
	// (ƂŏC)
	CContourDlg m_dlg;

	MGPickObjects m_surf; ///< Ƃ邽߂̖ʃf[^
	UINT m_nIDS; ///< error message
};

#endif // !defined(AFX_CONTOURTOOL_H__0D535F9E_AF4B_4CB6_B24E_E6C35165B563__INCLUDED_)
