/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CornerR_CPRTool.cpp
 * @brief MGCornerR_CPRTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "CurveCmd/CornerR_CPRTool.h"
#include "GLInputRealDlg.h"
#include "mg/Ellipse.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCornerR_CPRTool
// Creates an arc from a curve, the arc's end point, and the radius.

MGCornerR_CPRTool::MGCornerR_CPRTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_CURVE_CORNER_R_CPR,NO_RUBBER,POINT_IPDRAW){
	turn_on_near();
	turn_on_end();
}

MGCommandBase* MGCornerR_CPRTool::initial_clone(fugenDoc* pDoc)const{
	return new MGCornerR_CPRTool(pDoc);
}

bool MGCornerR_CPRTool::initiate_tool(){
	MGLocateState::initiate_tool();
	UserPreference& pref = UserPreference::getInstance();
	m_dRadius = pref.GetDoubleValue(upv_Curve_CornerArcCPR_Radius);
	clear_pick_object();
	return false;
}

bool MGCornerR_CPRTool::terminate_tool(bool cancel)
{
	UserPreference& pref = UserPreference::getInstance();
	pref.SetDoubleValue(upv_Curve_CornerArcCPR_Radius, m_dRadius);

	return MGLocateState::terminate_tool(cancel);
}

bool MGCornerR_CPRTool::input_param(){
	SetStatusMessage(IDS_PROMPT_CIRCLE_RADIUS);
	CString str;
	VERIFY(str.LoadString(IDS_CAPTION_CORNER_R));

	CGLInputRealDlg dlg(CString(), str);
	dlg.SetValue(m_dRadius);
	bool bOK = (IDOK == dlg.DoModal());
	if(bOK){
		m_dRadius = dlg.GetValue();
	}
	return bOK;
}

bool MGCornerR_CPRTool::OnCommandEnd(
	UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
	bool erase_temporary_display
){
	const LInfoVec& linfos=locates();
	if(linfos.size()<1)
		return MGLocateState::OnCommandEnd(3);

	if(!input_param()){
		// cancel
		return MGLocateState::OnCommandEnd(3);
	}

	// vZJn
	SetStatusMessage(IDS_PROMPT_COMPUTE);
	CWaitCursor sandglass;

	// m[}
	const MGCurve& c1=*(static_cast<const MGCurve*>(linfos[0]->object()));
	double t1=linfos[0]->curve_parameter();
	MGPosition pos1 = c1.eval(t1);
	const MGPosition& pos2 = linfos[1]->point_world();
	MGVector v1 = c1.eval(t1, 1);
	
	int error;
	std::unique_ptr<MGEllipse> arc(new MGEllipse(c1,pos2,v1*(pos2-pos1),m_dRadius,t1,error));
	if(error){
		// failed
		return MGLocateState::OnCommandEnd(IDS_FAIL_GENERATE_CURVE);
	}
	add_object_to_current_group(arc.release());
	return MGLocateState::OnCommandEnd(nIDS);
}

bool MGCornerR_CPRTool::OnLocated(const MGLocateInfo& info){
	if(info.is_deleted()){
		return false;
	}

	const LInfoVec& linfos=locates();
	size_t np=linfos.size();
	if(np==1){
		// J[u
		const MGCurve* curve = dynamic_cast<const MGCurve*>(info.object());
		if(!curve){
			// Ȑ̓_ȊÕNbN͔F߂Ȃ
			cancel_last_locate();
		}
		return false;
	}

	if(np==2){
		// vZJn
		return OnCommandEnd(1);
	}
	return false;
}

void MGCornerR_CPRTool::prompt_message() const{
	size_t np=locates().size();
	if(!np){
		SetStatusMessage(IDS_PROMPT_BASELINE);
	}else{
		SetStatusMessage(IDS_PROMPT_CORNER_R_END);
	}
}
