/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CornerR_CCRTool.h
 * @brief MGCornerR_CCRTool NX̃C^[tFCX
 */
#if !defined(AFX_CORNERR_CCRTOOL_H__B6DF6511_EC6F_42FD_9EE0_5D2B5EEA4AA4__INCLUDED_)
#define AFX_CORNERR_CCRTOOL_H__B6DF6511_EC6F_42FD_9EE0_5D2B5EEA4AA4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

class MGCommandStateOwner;

/// @class MGCornerR_CCRTool CornerR_CCRTool.h "CurveCmd/CornerR_CCRTool.h"
///
/// Creates an ard from two tangent curves and the radius.
class MGCornerR_CCRTool : public MGLocateState{
public:
	explicit MGCornerR_CCRTool(fugenDoc* pDoc);
	explicit MGCornerR_CCRTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	bool input_param(
		const MGPosition& p1,	//sample point 1.
		const MGPosition& p2,	//sample point 2.
		double& radius			//radius will be output.
		);
	void prompt_message() const;
};

#endif // !defined(AFX_CORNERR_CCRTOOL_H__B6DF6511_EC6F_42FD_9EE0_5D2B5EEA4AA4__INCLUDED_)
