/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CornerR_CCPTool.h
 * @brief MGCornerR_CCPTool NX̃C^[tFCX
 */
#if !defined(AFX_CORNERR_CCP_H__B2F343B3_3DC6_4CF8_84E7_30D7877E8BEA__INCLUDED_)
#define AFX_CORNERR_CCP_H__B2F343B3_3DC6_4CF8_84E7_30D7877E8BEA__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGCornerR_CCPTool CornerR_CCPTool.h "CurveCmd/CornerR_CCPTool.h"
///
/// Creates an arc from a tangent curves and a tangent point of another curve.
class MGCornerR_CCPTool : public MGLocateState{
public:
	explicit MGCornerR_CCPTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnLocated(const MGLocateInfo& info);
	
private:
	void prompt_message() const;
};

#endif // !defined(AFX_CORNERR_CCP_H__B2F343B3_3DC6_4CF8_84E7_30D7877E8BEA__INCLUDED_)
