/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CornerR_C3Tool.h
 * @brief MGCornerR_C3Tool NX̃C^[tFCX
 */
#if !defined(AFX_CORNERR_C3TOOL_H__2D84AF11_0178_43ED_8513_9EE713B26164__INCLUDED_)
#define AFX_CORNERR_C3TOOL_H__2D84AF11_0178_43ED_8513_9EE713B26164__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGCornerR_C3Tool CornerR_C3Tool.h "CurveCmd/CornerR_C3Tool.h"
///
/// Creates an arc from three tangent curves.
class MGCornerR_C3Tool : public MGLocateState{
public:
	explicit MGCornerR_C3Tool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnLocated(const MGLocateInfo& info);

private:
	void prompt_message() const;
};

#endif // !defined(AFX_CORNERR_C3TOOL_H__2D84AF11_0178_43ED_8513_9EE713B26164__INCLUDED_)
