/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// Conic.h: MGConicTool NX̃C^[tFCX

#if !defined(AFX_CONIC_H__6262430E_3751_4EEC_B1CB_635F29577751__INCLUDED_)
#define AFX_CONIC_H__6262430E_3751_4EEC_B1CB_635F29577751__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"
#include "mg/Curve.h"

// class MGConicTool
//
// ~Ȑ𐶐R}h
class MGConicTool : public MGLocateState{
public:
	explicit MGConicTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	std::unique_ptr<MGCurve> makeModel(const MGPosition& P3);
	void prompt_message() const;
	double     m_rho;      //  w / (1 + w) ƂĎgp; (0, 1) ɂ邱
	// through, rho ͓Ɏgp邱Ƃ͂Ȃ...
};

#endif // !defined(AFX_CONIC_H__6262430E_3751_4EEC_B1CB_635F29577751__INCLUDED_)
