/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CircleVertical.h
 * @brief MGCircleVerticalTool NX̃C^[tFCX
 */
#pragma once

#include "Common/LocateState.h"

class MGEllipse;

/// @class MGCircleVerticalTool CircleVertical.h "CurveCmd/CircleVertical.h"
///
/// ~R}h̐쐬[hB
class MGCircleVerticalTool : public MGLocateState{
	bool m_b2P; ///< 2 _w胂[h
	MGVector m_normal;///normal of the cplane on which the 1st point input.

public:
	//explicit MGCircleVerticalTool(fugenDoc* pDoc);
	explicit MGCircleVerticalTool(MGCommandStateOwner* owner);

	//virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	std::unique_ptr<MGEllipse> makeModel(const MGPosition& P1) const;
	void prompt_message() const;
};
