/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CircleVertical.cpp
 * @brief MGCircleVerticalTool NX̃Cve[V
 */
#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "Common/CommandStateOwner.h"
#include "CurveCmd/CircleVertical.h"

#include "mg/Ellipse.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGCircleVerticalTool

MGCircleVerticalTool::MGCircleVerticalTool(MGCommandStateOwner* owner)
: MGLocateState(owner, UNLOCK_SNAP_ATTRIB, LINE_RUBBER, POINT_IPDRAW),
m_b2P(false){
}

void MGCircleVerticalTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	std::unique_ptr<MGEllipse> circle=makeModel(cursor());
	if(circle.get()){
		MGColor::get_instance(MGColor::SpringGreen).exec(sgl);
		circle->drawWire(sgl);
	}
}

bool MGCircleVerticalTool::OnKeyDown(
	fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags
){
	switch(nChar){
	case 'p':
	case 'P':
		if(locates().empty()){
			m_b2P = true;
		}
		break;
	default:;
	}
	return MGLocateState::OnKeyDown(pView, nChar, nRepCnt, nFlags);
}

bool MGCircleVerticalTool::OnLocated(const MGLocateInfo& info){
	const LInfoVec& linfos=locates();
	switch(linfos.size()){
	case 0:
		break;
	case 1:
		m_normal=linfos[0]->window()->cplane().plane().normal();
		break;
	case 2:
		{
			std::unique_ptr<MGEllipse> circle=makeModel(linfos[1]->point_world());
			// vZJn
			if(circle.get()){
				add_object_to_current_group(circle.release());
				return OnCommandEnd(1);
			}else{
				// failed
				return OnCommandEnd(2);
			}
		}
	default:
		;
	}
	return false;
}

std::unique_ptr<MGEllipse> MGCircleVerticalTool::makeModel(const MGPosition& P1)const{
	std::unique_ptr<MGEllipse> circle;
	const LInfoVec& linfos=locates();
	if(linfos.size()){
		const MGPosition& P0=linfos[0]->point_world();
		const MGPosition& center = m_b2P ? (P0+P1)*.5 : P0;
		MGVector normal = m_normal * (P1-center);
		double radius = center.distance(P1);
		circle=std::unique_ptr<MGEllipse>(new MGEllipse(center, radius, normal));
	}
	return circle;
}

void MGCircleVerticalTool::prompt_message() const{
	switch(locates().size()){
	case 0:
		SetStatusMessage(
			m_b2P ? IDS_PROMPT_CIRCLE_VERT_START : IDS_PROMPT_CIRCLE_VERT_CENTER);
		break;
	case 1:
		SetStatusMessage(
			m_b2P ? IDS_PROMPT_CIRCLE_VERT_END : IDS_PROMPT_CIRCLE_RADIUS);
		break;
	}
}
