/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CircleTTRTool.h
 * @brief MGCircleTTRTool NX̃C^[tFCX
 */
#if !defined(AFX_CIRCLETTRTOOL_H__D0141680_0D15_4E2D_A619_445791CC8433__INCLUDED_)
#define AFX_CIRCLETTRTOOL_H__D0141680_0D15_4E2D_A619_445791CC8433__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

class MGCommandStateOwner;

/// @class MGCircleTTRTool CircleTTRTool.h "CurveCmd/CircleTTRTool.h"
///
/// Creates a circle from two tangent curves and the radius.
class MGCircleTTRTool : public MGLocateState{
public:
	explicit MGCircleTTRTool(fugenDoc* pDoc);
	explicit MGCircleTTRTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);
	virtual bool OnLocated(const MGLocateInfo& info);
	
private:
	bool input_param();
	void prompt_message() const;

	double m_dRadius; ///< a
};

#endif // !defined(AFX_CIRCLETTRTOOL_H__D0141680_0D15_4E2D_A619_445791CC8433__INCLUDED_)
