/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CircleT3Tool.h
 * @brief MGCircleT3Tool NX̃C^[tFCX
 */
#if !defined(AFX_CIRCLET3TOOL_H__99F95D02_089F_4271_8690_9B3AB3FB496A__INCLUDED_)
#define AFX_CIRCLET3TOOL_H__99F95D02_089F_4271_8690_9B3AB3FB496A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGCircleT3Tool CircleT3Tool.h "CurveCmd/CircleT3Tool.h"
///
/// Creates a circle from tangent points of three curves.
class MGCircleT3Tool : public MGLocateState{
public:
	explicit MGCircleT3Tool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
		);

	virtual bool OnLocated(const MGLocateInfo& info);

private:
	void prompt_message() const;
};

#endif // !defined(AFX_CIRCLET3TOOL_H__99F95D02_089F_4271_8690_9B3AB3FB496A__INCLUDED_)
