/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CircleDiamTool.h
 * @brief MGCircleDiamTool NX̃C^[tFCX
 */
#if !defined(AFX_CIRCLEDIAMTOOL_H__D64A9E51_DC15_4D28_8C82_DF00726FA11A__INCLUDED_)
#define AFX_CIRCLEDIAMTOOL_H__D64A9E51_DC15_4D28_8C82_DF00726FA11A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mg/Ellipse.h"
#include "Common/LocateState.h"

class MGCommandStateOwner;

/// @class MGCircleDiamTool CircleDiamTool.h "CurveCmd/CircleDiamTool.h"
///
/// Creates a circle from both endpoints of the diameter line.
class MGCircleDiamTool : public MGLocateState{
public:
	explicit MGCircleDiamTool(fugenDoc* pDoc);
	explicit MGCircleDiamTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	
private:
	std::unique_ptr<MGCurve> makeModel(const MGPosition& P1);
	void prompt_message() const;
};

#endif // !defined(AFX_CIRCLEDIAMTOOL_H__D64A9E51_DC15_4D28_8C82_DF00726FA11A__INCLUDED_)
