/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CircleCRTool.h
 * @brief MGCircleCRTool NX̃C^[tFCX
 */
#if !defined(AFX_CIRCLECRTOOL_H__B5B92DD8_F211_40F2_83D5_B2CBDD71009A__INCLUDED_)
#define AFX_CIRCLECRTOOL_H__B5B92DD8_F211_40F2_83D5_B2CBDD71009A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

class MGCommandStateOwner;
class MGCurve;

/// @class MGCircleCRTool CircleCRTool.h "CurveCmd/CircleCRTool.h"
///
/// Creates a circle from the center point and the radius.
class MGCircleCRTool : public MGLocateState
{
	std::unique_ptr<MGCurve> m_spPreview; ///< vr[f[^

public:
	explicit MGCircleCRTool(fugenDoc* pDoc);
	explicit MGCircleCRTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnKeyDown(fugenView*, UINT, UINT, UINT);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	void prompt_message() const;

private:
	std::unique_ptr<MGCurve> makeModel(const MGPosition& P1);
};

#endif // !defined(AFX_CIRCLECRTOOL_H__B5B92DD8_F211_40F2_83D5_B2CBDD71009A__INCLUDED_)
