/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file Circle3P.h
 * @brief MGCircle3P NX̃C^[tFCX
 */
#if !defined(AFX_CIRCLE3P_H__01915CA1_F138_4D39_BEED_677110BF9997__INCLUDED_)
#define AFX_CIRCLE3P_H__01915CA1_F138_4D39_BEED_677110BF9997__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mg/Ellipse.h"
#include "Common/LocateState.h"

class MGCommandStateOwner;

/// @class MGCircle3PTool Circle3P.h "CurveCmd/Circle3P.h"
///
/// Creates a circle from three points on the circumference.
class MGCircle3PTool : public MGLocateState{
public:
	explicit MGCircle3PTool(fugenDoc* pDoc);
	explicit MGCircle3PTool(MGCommandStateOwner* owner);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);
	
private:
	void prompt_message() const;
};

#endif // !defined(AFX_CIRCLE3P_H__01915CA1_F138_4D39_BEED_677110BF9997__INCLUDED_)
