/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#if !defined(AFX_CURVADLG_H__DD05405A_62EF_49CC_BE12_6BDB44118D50__INCLUDED_)
#define AFX_CURVADLG_H__DD05405A_62EF_49CC_BE12_6BDB44118D50__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "mgModelessDialogue.h"

class fugenDoc;
class MGEvalCurveCurvatureTool;

/////////////////////////////////////////////////////////////////////////////
// CCurvaDlg _CAO

// As usual, class CCurvaDlg is used as a modeless dialog box
// while displaying curvature graph of curves.
class CCurvaDlg : public mgModelessDialogue{
	friend class MGEvalCurveCurvatureTool;

	double m_dScaleMin, m_dScaleMax;///<minimum/maximum of m_dScale(graph length scale).
	int m_nDensMin, m_nDensMax;///<minimum/maximum of m_nDensity(graph draw density).

// _CAO f[^
	//{{AFX_DATA(CCurvaDlg)
	CSpinButtonCtrl m_spnScale;
	double m_dScale;///<graph length scale.

	CSpinButtonCtrl m_spnDens;
	int m_nDensity;///<graph draw density.

	int m_nType;///<Graph type, =0:curvature graph, =1:curvature radius graph.
	BOOL m_bNegate;///True if curvature is outer and curvature radius is inner.
	//}}AFX_DATA

public:

	//Dialoge id=IDD_CURVA_DLG.
	CCurvaDlg(MGEvalCurveCurvatureTool* tool);

	int GetDensity() const{	return m_nDensity;};
	double GetScale() const{return m_dScale;};

	//! @retval 0 length is usual curvature
	//! @retval 1 length is radius of curvature
	int GetLengthType() const{ return m_nType; };

	BOOL Negate() const{ return m_bNegate; };


	// I[o[Ch
protected:
	//{{AFX_VIRTUAL(CCurvaDlg)
	BOOL OnInitDialog() override;
	void DoDataExchange(CDataExchange* pDX) override;
	void PostNcDestroy() override;
	void OnOK() override;
	//void OnCancel() override; uses default OnCancel().
	//}}AFX_VIRTUAL

// Cve[V
protected:

	// ꂽbZ[W }bv֐
	//{{AFX_MSG(CCurvaDlg)
	afx_msg void OnDeltaposSpin(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void UpdateView();
	//}}AFX_MSG

private:
	void LoadUserPref();
	void SaveUserPref() const;

	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_CURVADLG_H__DD05405A_62EF_49CC_BE12_6BDB44118D50__INCLUDED_)
