/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
// CurvaDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "mg/Curve.h"
#include "CurvaDlg.h"
#include "EvalCmd/EvalCurveCurvatureTool.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCurvaDlg _CAO

//Dialoge id=IDD_CURVA_DLG.
CCurvaDlg::CCurvaDlg(MGEvalCurveCurvatureTool* tool)
:mgModelessDialogue(tool){
	LoadUserPref();
	Create(IDD_CURVA_DLG);
}

BOOL CCurvaDlg::OnInitDialog(){
	mgModelessDialogue::OnInitDialog();

	m_dScaleMin = 0.;
	m_spnScale.SetRange32(1, 100); // ׂ͂ł悢
	m_spnDens.SetRange32(m_nDensMin, m_nDensMax);
	return TRUE;
}

void CCurvaDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCurvaDlg)
	DDX_Control(pDX, IDC_CURVA_SCALE_SPIN, m_spnScale);
	DDX_Text(pDX, IDC_CURVA_SCALE, m_dScale);
	DDV_MinMaxDouble(pDX, m_dScale, m_dScaleMin, m_dScaleMax);

	DDX_Control(pDX, IDC_CURVA_DENS_SPIN, m_spnDens);
	DDX_Text(pDX, IDC_CURVA_DENSITY, m_nDensity);
	DDV_MinMaxInt(pDX, m_nDensity, m_nDensMin, m_nDensMax);

	DDX_Radio(pDX, IDC_CURVA_RADIO, m_nType);
	DDX_Check(pDX, IDC_CURVA_CHECK_NEGATE, m_bNegate);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCurvaDlg, mgModelessDialogue)
	//{{AFX_MSG_MAP(CCurvaDlg)
	ON_NOTIFY(UDN_DELTAPOS, IDC_CURVA_DENS_SPIN, OnDeltaposSpin)
	ON_NOTIFY(UDN_DELTAPOS, IDC_CURVA_SCALE_SPIN, OnDeltaposSpin)
	ON_BN_CLICKED(IDC_CURVA_RADIO, UpdateView)// WI{^
	ON_BN_CLICKED(IDC_CURVA_RADIO2, UpdateView)
	ON_BN_CLICKED(IDC_CURVA_CHECK_NEGATE, UpdateView)// ]`FbN{bNX
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CCurvaDlg::LoadUserPref(){
	UserPreference& pref = UserPreference::getInstance();
	m_nType = pref.GetIntValue(upv_Eval_CurveCurvature_Type);
	pref.GetDoubleValue(upv_Eval_CurveCurvature_Scale, m_dScale, m_dScaleMin, m_dScaleMax);
	pref.GetIntValue(upv_Eval_CurveCurvature_Density, m_nDensity, m_nDensMin, m_nDensMax);
	m_bNegate = pref.GetBoolValue(upv_Eval_CurveCurvature_Negate);
}

void CCurvaDlg::SaveUserPref() const{
	UserPreference& pref = UserPreference::getInstance();
	pref.SetIntValue(upv_Eval_CurveCurvature_Type, m_nType);
	pref.SetDoubleValue(upv_Eval_CurveCurvature_Scale, m_dScale);
	pref.SetIntValue(upv_Eval_CurveCurvature_Density, m_nDensity);
	pref.SetBoolValue(upv_Eval_CurveCurvature_Negate, m_bNegate==TRUE);
}

void CCurvaDlg::UpdateView(){
	UpdateData();
	MGEvalCurveCurvatureTool* tool =
		static_cast<MGEvalCurveCurvatureTool*>(getCmdTool());
	if(tool)
		tool->draw_graph();
}

#define DELTA .02
// Xs{^
void CCurvaDlg::OnDeltaposSpin(NMHDR* pNM, LRESULT* pResult){
	NM_UPDOWN* pUpDown = reinterpret_cast<NM_UPDOWN*>(pNM);
	// 64bitłUINT_PTR^ƂȂB
	// NotifynCxg̏ꍇAǂ̃Rg[ʒmꂽ̂Ă

	UINT nIDC = (UINT)pUpDown->hdr.idFrom;
	switch(nIDC){
	case IDC_CURVA_SCALE_SPIN:// OŃCNg
		m_dScale += pUpDown->iDelta*DELTA;
		m_dScale = std::max(m_dScale, m_dScaleMin);
		m_dScale = std::min(m_dScale, m_dScaleMax);
		UpdateData(FALSE);
		break;
	case IDC_CURVA_DENS_SPIN: break;
	default: *pResult = 1; break;
	}
	UpdateView();
}

void CCurvaDlg::OnOK(){
	UpdateView();
	mgModelessDialogue::OnOK();
}

void CCurvaDlg::PostNcDestroy(){
	// [hX_CAOȂ̂ delete this B
	SaveUserPref();
	mgModelessDialogue::PostNcDestroy();
}
