#include "stdafx.h"
#include "CoordinateArrow.h"

#include "mgGL/VBOLeaf.h"
#include "mgGL/VBObyAnchorPt.h"
#include "mgGL/MGStringWriter.h"

CoordinateArrow::CoordinateArrow(float z)
:mgVBOByScreen(z){
}


CoordinateArrow::~CoordinateArrow(void){
}

///make coordinate arrows.
///data[] are all of screen coordinates.
///([0],[0]) is the origin to display,([1],[2]) is x axis vector from the origin,
///([3],[4]) is y, and ([5],[6]) is z.
///From the coordinate ([0],[0]) to ([0]+[1],[0]+[2]) is the coordinate line.
void CoordinateArrow::makeCoordinateArrow(const int data[7]){
	Begin(GL_LINES);
		setStaticAttribLineWidth(1.f);
		const int& x0=data[0];
		const int& y0=data[0];
		Vertex(x0,y0); Vertex(x0+data[1],y0+data[2]);
		Vertex(x0,y0); Vertex(x0+data[3],y0+data[4]);
		Vertex(x0,y0); Vertex(x0+data[5],y0+data[6]);
	m_arrows=End();

	int xend[2]={x0+data[1],y0+data[2]};
	float Xx, Xy;convert2NormalizedWorld(xend,Xx,Xy);
	int yend[2]={x0+data[3],y0+data[4]};
	float Yx, Yy;convert2NormalizedWorld(yend,Yx,Yy);
	int zend[2]={x0+data[5],y0+data[6]};
	float Zx, Zy;convert2NormalizedWorld(zend,Zx,Zy);

	m_xAxisLabel = MGStringWriter::DrawByScreen("X", MGPosition(Xx, Xy, m_z));
	push_back_element(m_xAxisLabel);

	m_yAxisLabel = MGStringWriter::DrawByScreen("Y", MGPosition(Yx, Yy, m_z));
	push_back_element(m_yAxisLabel);

	m_zAxisLabel = MGStringWriter::DrawByScreen("Z", MGPosition(Zx, Zy, m_z));
	push_back_element(m_zAxisLabel);
	setDirty(false);
}

void CoordinateArrow::makeCoordinateArrow(const int data[7], LPCTSTR axis1, LPCTSTR axis2)
{

	Begin(GL_LINES);
		setStaticAttribLineWidth(1.f);
		const int& x0=data[0];
		const int& y0=data[0];
		Vertex(x0,y0); Vertex(x0+data[1],y0+data[2]);
		Vertex(x0,y0); Vertex(x0+data[3],y0+data[4]);
		Vertex(x0,y0); Vertex(x0+data[5],y0+data[6]);
	m_arrows=End();

	int xend[2]={x0+data[1],y0+data[2]};
	float Xx, Xy;convert2NormalizedWorld(xend,Xx,Xy);
	int yend[2]={x0+data[3],y0+data[4]};
	float Yx, Yy;convert2NormalizedWorld(yend,Yx,Yy);
	int zend[2]={x0+data[5],y0+data[6]};
	float Zx, Zy;convert2NormalizedWorld(zend,Zx,Zy);

	m_xAxisLabel = MGStringWriter::DrawByScreen(axis1, MGPosition(Xx, Xy, m_z));
	push_back_element(m_xAxisLabel);

	m_yAxisLabel = MGStringWriter::DrawByScreen(axis2, MGPosition(Yx, Yy, m_z));
	push_back_element(m_yAxisLabel);

	m_zAxisLabel = MGStringWriter::DrawByScreen("", MGPosition(Zx, Zy, m_z));
	push_back_element(m_zAxisLabel);
	setDirty(false);
}

void CoordinateArrow::updateCoordinateArrow(const int data[7]){
	const int& x0=data[0];
	const int& y0=data[0];
	int orgn[2]={x0,y0};
	float Ox, Oy;convert2NormalizedWorld(orgn,Ox,Oy);
	int xend[2]={x0+data[1],y0+data[2]};
	float Xx, Xy;convert2NormalizedWorld(xend,Xx,Xy);
	int yend[2]={x0+data[3],y0+data[4]};
	float Yx, Yy;convert2NormalizedWorld(yend,Yx,Yy);
	int zend[2]={x0+data[5],y0+data[6]};
	float Zx, Zy;convert2NormalizedWorld(zend,Zx,Zy);
	float arrowsData[18]={
		 Ox,Oy,m_z, Xx,Xy,m_z
		,Ox,Oy,m_z, Yx,Yy,m_z
		,Ox,Oy,m_z, Zx,Zy,m_z};

	m_arrows->updateVertices(0,6,arrowsData);

	m_xAxisLabel->setStaticAttribAnchorPoint(MGPosition(Xx,Xy,m_z));
	m_yAxisLabel->setStaticAttribAnchorPoint(MGPosition(Yx,Yy,m_z));
	m_zAxisLabel->setStaticAttribAnchorPoint(MGPosition(Zx,Zy,m_z));
}
