/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// ContourDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "ContourDlg.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CContourDlg _CAO

CContourDlg::CContourDlg(const MGBox& border)
: CDialog(CContourDlg::IDD, 0), m_bxBound(border){
	//{{AFX_DATA_INIT(CContourDlg)
	m_dPitch = 2.0;
	m_bSliceX = FALSE;
	m_bSliceY = FALSE;
	m_bSliceZ = FALSE;
	//}}AFX_DATA_INIT
}

void CContourDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CContourDlg)
	DDX_Control(pDX, IDC_STATIC_CONTOUR_Z, m_staZ);
	DDX_Control(pDX, IDC_STATIC_CONTOUR_Y, m_staY);
	DDX_Control(pDX, IDC_STATIC_CONTOUR_X, m_staX);
	DDX_Text(pDX, IDC_CONTOUR_PITCH, m_dPitch);
	DDX_Check(pDX, IDC_CHECK_CONTOUR_X, m_bSliceX);
	DDX_Check(pDX, IDC_CHECK_CONTOUR_Y, m_bSliceY);
	DDX_Check(pDX, IDC_CHECK_CONTOUR_Z, m_bSliceZ);
	DDX_Text(pDX, IDC_EDIT_CONTOUR_X, m_dThroughX);
	DDX_Text(pDX, IDC_EDIT_CONTOUR_Y, m_dThroughY);
	DDX_Text(pDX, IDC_EDIT_CONTOUR_Z, m_dThroughZ);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CContourDlg, CDialog)
	//{{AFX_MSG_MAP(CContourDlg)
	ON_BN_CLICKED(IDC_CHECK_CONTOUR_X, OnCheckX)
	ON_BN_CLICKED(IDC_CHECK_CONTOUR_Y, OnCheckY)
	ON_BN_CLICKED(IDC_CHECK_CONTOUR_Z, OnCheckZ)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

INT_PTR CContourDlg::DoModal(){
	INT_PTR nRet = CDialog::DoModal();
	SaveParam();
	return nRet;
}

void CContourDlg::LoadParam()
{
	UserPreference& pref = UserPreference::getInstance();

	m_dPitch = pref.GetDoubleValue(upv_Curve_Contour_Pitch);
	m_bSliceX = pref.GetBoolValue(upv_Curve_Contour_SliceX);
	m_bSliceY = pref.GetBoolValue(upv_Curve_Contour_SliceY);
	m_bSliceZ = pref.GetBoolValue(upv_Curve_Contour_SliceZ);
}

void CContourDlg::SaveParam() const
{
	UserPreference& pref = UserPreference::getInstance();

	pref.SetDoubleValue(upv_Curve_Contour_Pitch, m_dPitch);
	pref.SetBoolValue(upv_Curve_Contour_SliceX, m_bSliceX==TRUE);
	pref.SetBoolValue(upv_Curve_Contour_SliceY, m_bSliceY==TRUE);
	pref.SetBoolValue(upv_Curve_Contour_SliceZ, m_bSliceZ==TRUE);
}

/////////////////////////////////////////////////////////////////////////////
// CContourDlg bZ[W nh

BOOL CContourDlg::OnInitDialog(){
	CDialog::OnInitDialog();

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	LoadParam();
	
	CString str;

	str.Format(IDS_FORMAT_CONTOUR, 'X', m_bxBound[0].low_point(), m_bxBound[0].high_point());
	m_staX.SetWindowText(str);
	
	str.Format(IDS_FORMAT_CONTOUR, 'Y', m_bxBound[1].low_point(), m_bxBound[1].high_point());
	m_staY.SetWindowText(str);
	
	str.Format(IDS_FORMAT_CONTOUR, 'Z', m_bxBound[2].low_point(), m_bxBound[2].high_point());
	m_staZ.SetWindowText(str);
	
	m_dThroughX = MGCL::decimalAlign(m_bxBound[0].mid_point());
	m_dThroughY = MGCL::decimalAlign(m_bxBound[1].mid_point());
	m_dThroughZ = MGCL::decimalAlign(m_bxBound[2].mid_point());

	UpdateData(FALSE);
	OnCheckX();
	OnCheckY();
	OnCheckZ();

	return TRUE;
}

void CContourDlg::OnCheckX(){
	UpdateData();
	CWnd* pWnd = GetDlgItem(IDC_EDIT_CONTOUR_X);
	pWnd->EnableWindow(m_bSliceX);
}

void CContourDlg::OnCheckY(){
	UpdateData();
	CWnd* pWnd = GetDlgItem(IDC_EDIT_CONTOUR_Y);
	pWnd->EnableWindow(m_bSliceY);
}

void CContourDlg::OnCheckZ(){
	UpdateData();
	CWnd* pWnd = GetDlgItem(IDC_EDIT_CONTOUR_Z);
	pWnd->EnableWindow(m_bSliceZ);
}