/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/**
 * @file RectDrawer.cpp
 * @brief RectDrawer.h ̎
 */
#ifndef _MGRectDRAWER_HH_
#define _MGRectDRAWER_HH_

#include "mgGL/Color.h"
#include "mgGL/VBOLeaf.h"
#include "mgGL/VBOByScreen.h"
#include "fugenView.h"
//
//Implements mgRectDrawer Class.
//mgRectDrawer is a class to draw a rectangle using MGOpenGLVIew's
//command drawer function.
class mgRectDrawer: public mgVBOByScreen{

public:

//////////Constructor//////////

mgRectDrawer(
	const MGColor& lineColor=MGColor::get_instance(MGColor::White),
	float lineWidth=1.f
);

~mgRectDrawer();

///pViewwindowɂmgRectDrawerattachƓmgVBOByScreen
///set_viewport()𔭐MAΏwindowm肷
void attatchToWindow(
	fugenView* pView
);

///pViewwindow炱mgRectDrawerdetach
bool detachFromWindow(
);

fugenView* getAttatchedWindow(){return m_targetWindow;};

///windowbutton_down_point()mousemove_new_point()ɂlp`̓_update
void updateRectangle(
);

///_ƂwindowWn2_͂Ďlp`̓_update
void updateRectangle(
	const CPoint& P1, const CPoint& P2
);

///_ƂwindowWn2_͂Ďlp`̓_update
void updateRectangle(
	const int sxy1[2],	///<ΏWindow̒_̂ЂƂ͂
	const int sxy2[2]	///<ΏWindow̒_̂ӂ߂͂
);

///NDCWlō(x1,y1)ƉE(x2,y2)̃f[^^Ďlp``f[^쐬
void makeRectangle(float x1,float y1, float x2,float y2);

private:

	fugenView* m_targetWindow;///< window this is attached to.
	MGColor m_lineColor;///<Color to draw line.
	float m_lineWidth;///<Line width to draw line.

};

#endif
