/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 * @file CommandStateOwner.h
 * @brief NX MGCommandStateOwner ̐錾
 */
#if !defined(AFX_MGCommandStateOwner_H__A4AF74B6_A496_496F_8012_CDFF87747D18__INCLUDED_)
#define AFX_MGCommandStateOwner_H__A4AF74B6_A496_496F_8012_CDFF87747D18__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandBase.h"

/// class MGCommandStateOwner
///
/// R}h͈ʓIɕ̃Xebv
/// ueR}hvɍl:
/// 1. eȐ߂Xebv
/// 2. ǂɓê߂Xebv
/// 3. ěvZXebv
/// ƂȂ
///
/// ̊eXebv MGCommandBase ̔hNXŕ\
/// C̃R}hMGCommandStateOwnerŕ\
///
/// MGCommandStateOwner݂̃XebvێĂ
/// ̃Xebv݂͌̃XebvɑIuWFNgێ
///
/// ̃Xebv̕ύXMGCommandStateOwner::OnKeyDown
/// L[́E}EX͊֐Iɍs邱Ƃ
///
/// ܂hLg̕WR}hIuWFNgƂ
/// ̃NX̂̂(==hȂ)pĂ
class MGCommandStateOwner : public MGCommandBase{
public:
	
//	MGCommandStateOwner();

	/// static̈ɂIuWFNĝ߂̃RXgN^
	/// hLǵuWԁṽR}hIuWFNgł
	MGCommandStateOwner(fugenDoc* pDoc);

	/// hNXpRXgN^
	/// hLgƃR}hIDw肵ăIuWFNg𐶐
	MGCommandStateOwner(fugenDoc* pDoc, UINT nID);

	virtual ~MGCommandStateOwner();

	///MGCommandStateOwner::initiate_tool() always return false.
	virtual bool initiate_tool();  // override
	virtual bool terminate_tool(bool cancel); // override

	///Set the current state command.
	void set_child_current_command(
		MGCommandBase* currentState
	);

	///Set the next state command.
	void set_child_next_command(
		MGCommandBase* nextState
	);

	///Clear the current command state.
	///This will cause the termination of this command.
	void clear_state();

	///Get the next command.
	MGCommandBase* GetNextState(){ return m_next;}

	/// ݂̃Xebv\R}hIuWFNgԂ
	MGCommandBase* GetCurState(){ return m_state;}
	const MGCommandBase* GetCurState() const{ return m_state;}

	///update snap mode for locate.
	virtual void updateSnapMode(const MGSnapAttrib& sattrib);

public:
	// MGCommandStateOwner̃L[́E}EX͊֐ł
	// XebvIuWFNg̃oĂяoƃXebv̐iss

	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);
	virtual bool OnKeyUp(fugenView* window, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLButtonDblClk(fugenView* window,UINT nFlags, CPoint point);
	virtual bool OnLButtonDown(fugenView* window,UINT nFlags, CPoint point);
	virtual bool OnLButtonUp(fugenView* window,CPoint old_point,UINT nFlags, CPoint point);
	virtual bool OnMouseMove(fugenView* window,UINT nFlags, CPoint point);
	virtual bool OnMouseWheel(fugenView* window,UINT nFlags, short zDelta, CPoint pt);
	virtual bool OnRButtonDblClk(fugenView* window,UINT nFlags, CPoint point);
	virtual bool OnRButtonDown(fugenView* window,UINT nFlags, CPoint point);
	virtual bool OnRButtonUp(fugenView* window,CPoint old_point,UINT nFlags, CPoint point);
	virtual bool OnSetCursor(fugenView* pView, CWnd* pWnd, UINT nHitTest, UINT message);

	virtual void ModifyContextMenu(CMenu& popup);

	virtual bool CanHandle(UINT nID) const;
	virtual bool HandleMessage(UINT nID);
	virtual bool HandleUpdateUI(UINT nID, CCmdUI* pCmdUI);
	
protected:
	// ̃R}ȟ݂̃Xebv\R}hIuWFNgw
	// ̃XebvȂꍇ0Ƃ
	MGCommandBase* m_state;

	// R}h̊eԂMGCommandBase̔hNXŕ\邪
	// ǂ̏Ԃ̏Ԃ߂邱Ƃł
	// ̃IuWFNgm_nextƂ
	//
	// m_nextMGCommandBase̔hNX
	// ԃNXłƂɗLȃoł
	MGCommandBase*    m_next;

	// ̃XebvɈڍsƂɌĂ΂֐
	void ChangeState();

	friend class MGCommandBase;
};

#endif // !defined(AFX_DEFAULTCMD_H__A4AF74B6_A496_496F_8012_CDFF87747D18__INCLUDED_)
