#include "stdafx.h"
#include "MainFrm.h"
#include "fugenView.h"

#include "Common/CommandBase.h"
#include "Common/CommandStateOwner.h"


///Set active view as view.
void MGCommandBase::setActiveView(fugenView* view){
	fugenView* mview=document()->get_main_view();
	CFrameWnd* frame=mview->GetParentFrame();
	frame->SetActiveView(view);
}

void MGCommandBase::SetStatusMessageSub(LPCTSTR lpszMsg)const{
	::AfxGetMainWnd()->SendMessage(
		WM_GL_STATUSBAR, 0, (LPARAM)lpszMsg);
}

void MGCommandBase::SetStatusMessage(LPCTSTR lpszMsg)const{	
	const MGCommandBase* owner=get_owner_command();
	CString& msg=owner ? owner->message():message();
	msg=m_command_name;
	msg+=": ";
	msg+=lpszMsg;
	SetStatusMessageSub(msg);
}

// Xe[^Xo[ɕ\镶XV
void MGCommandBase::SetStatusMessage(UINT nIDS, ...)const{
	if(nIDS==0)
		return;

	CString strFormat;
	VERIFY(strFormat.LoadString(nIDS));

	va_list argList;
	va_start(argList, nIDS);
	CString msg;
	msg.FormatV(strFormat, argList);
	va_end(argList);

	// Xe[^Xo[ɕ\
	SetStatusMessage(msg);
}

//Clear the StatusMessage(including command name).
void MGCommandBase::ClearCommandMessage(){
	SetStatusMessageSub(_T(""));
}

const CString& MGCommandBase::command_name()const{
	const MGCommandBase* owner=get_owner_command();
	if(owner)
		return owner->m_command_name;
	return m_command_name;
}

CString& MGCommandBase::message()const{
	const MGCommandBase* owner=get_owner_command();
	if(owner)
		return owner->message();
	return m_message;
}

const mgModelessDialogue* MGCommandBase::getModelessDialogPointer()const {
	const MGCommandBase* owner=get_owner_command();
	if(owner)
		return owner->getModelessDialogPointer();
	else
		return m_modelesDialog; 
}

mgModelessDialogue* MGCommandBase::getModelessDialogPointer(){
	MGCommandBase* owner=get_owner_command();
	if(owner)
		return owner->getModelessDialogPointer();
	else
		return m_modelesDialog; 
}

void MGCommandBase::setModelessDialogPointer(mgModelessDialogue* dialog){
	MGCommandBase* owner = get_owner_command();
	if(owner)
		owner->setModelessDialogPointer(dialog);
	else{
		assert(!m_modelesDialog || !dialog);
		m_modelesDialog = dialog;
	}
}
