/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// CommandBarCtrl.h: CCommandBarCtrl NX̃C^[tFCX

#if !defined(AFX_COMMANDBARCTRL_H__38659507_4F55_41E5_90A0_6CB17EB3BF5A__INCLUDED_)
#define AFX_COMMANDBARCTRL_H__38659507_4F55_41E5_90A0_6CB17EB3BF5A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <vector>
#include <stack>

#define CBR_EX_TRANSPARENT	0x00000001L
#define CBR_EX_SHAREMENU	0x00000002L
#define CBR_EX_ALTFOCUSMODE	0x00000004L
#define CBR_EX_TRACKALWAYS	0x00000008L

// class CCommandBarCtrl
//
// mini CCommandBarCtrl of WTL.
// This class does not make a menu toolbar.
class CCommandBarCtrl
{
public:
	// constructor/destructor
	CCommandBarCtrl();
	~CCommandBarCtrl();

	// the maximum length of menu item string
	enum{
		_nMaxMenuItemTextLength = 100
	};
	// misc spacing in pixels
	enum _CmdBarDrawConstants
	{
		s_kcxGap = 1,
		s_kcxTextMargin = 2,
		s_kcxButtonMargin = 1,
		s_kcyButtonMargin = 1
	};
#ifndef DT_HIDEPREFIX
	enum { DT_HIDEPREFIX = 0x00100000 };
#endif //!DT_HIDEPREFIX

	struct _MenuItemData	// menu item data
	{
		DWORD dwMagic;
		LPTSTR lpstrText;
		UINT fType;
		UINT fState;
		int iButton;

		_MenuItemData() { dwMagic = 0x1313; }
		bool IsCmdBarMenuItem() { return (dwMagic == 0x1313); }
	};
	struct _ToolBarData	// toolbar resource data
	{
		WORD wVersion;
		WORD wWidth;
		WORD wHeight;
		WORD wItemCount;
		//WORD aItems[wItemCount]

		WORD* items()
			{ return (WORD*)(this+1); }
	};

	// data members

	HMENU m_hMenu;
	HIMAGELIST m_hImageList;
	DWORD m_dwExtendedStyle;	// Command Bar specific extended styles
	std::vector<DWORD> m_arrCommand;

	std::stack<HMENU> m_stackMenuHandle;

	bool m_bAttachedMenu;
	bool m_bAlphaImages;
	bool m_bMenuActive;
	bool m_bImagesVisible;
	bool m_bFlatMenus;
	bool m_bShowKeyboardCues;

	SIZE m_szBitmap;
	SIZE m_szButton;

	COLORREF m_clrMask;
	CFont m_fontMenu;		// used internally, only to measure text

	int m_cxExtraSpacing;

//	BOOL AttachMenu(HMENU hMenu);
	bool CreateInternalImageList(int cImages);
	BOOL DrawCheckmark(CDC& dc, const CRect& rc, BOOL bSelected, BOOL bDisabled, BOOL bRadio, HBITMAP hBmpCheck);
	void DrawItem3D(LPDRAWITEMSTRUCT lpDrawItemStruct);
	void DrawBitmapDisabled(
		CDC& dc, 
		int nImage, 
		POINT point,
		HBRUSH hBrushBackground = ::GetSysColorBrush(COLOR_3DFACE),
		HBRUSH hBrush3DEffect = ::GetSysColorBrush(COLOR_3DHILIGHT),
		HBRUSH hBrushDisabledImage = ::GetSysColorBrush(COLOR_3DSHADOW));

	void DrawMenuText(CDC& dc, RECT& rc, LPCTSTR lpstrText, COLORREF color);
	void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	void GetSystemSettings();
	BOOL LoadImages(UINT nRes){
		return LoadImages(MAKEINTRESOURCE(nRes));
	}
	BOOL LoadImages(LPCTSTR lpszRes);
	void MeasureItem(LPMEASUREITEMSTRUCT lpMeasureItemStruct);

	bool SetImageSize(SIZE& size){
		return SetImageSize(size.cx, size.cy);
	}
	bool SetImageSize(int cx, int cy);


	void OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct);
	void OnInitMenuPopup(CMenu* pPopupMenu, UINT nIndex, BOOL bSysMenu);
	void OnMeasureItem(int nIDCtl, LPMEASUREITEMSTRUCT lpMeasureItemStruct);
	void OnMenuSelect(UINT nItemID, UINT nFlags, HMENU hSysMenu);

private:
	BOOL DitherBlt(
		CDC& dc,
		int x, int y, int nWidth, int nHeight, HDC hSrcDC, HBITMAP hBitmap, int xSrc, int ySrc,
		HBRUSH hBrushBackground = ::GetSysColorBrush(COLOR_3DFACE),
		HBRUSH hBrush3DEffect = ::GetSysColorBrush(COLOR_3DHILIGHT),
		HBRUSH hBrushDisabledImage = ::GetSysColorBrush(COLOR_3DSHADOW)
		);
};

#endif // !defined(AFX_COMMANDBARCTRL_H__38659507_4F55_41E5_90A0_6CB17EB3BF5A__INCLUDED_)
