/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

// project.cpp
#include "stdafx.h"
#include "mg/Point.h"
#include "mg/Straight.h"
#include "mg/CSisects.h"
#include "topo/Shell.h"
#include "Calc/mgproject.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

namespace mgcalc{

	// ef[^Zbg
	MGProject::MGProject(
		const MGObject* objective,
		const MGObject* subjective,
		const MGVector& direction
		): m_objective(objective),
		   m_subjective(subjective),
		   m_direction(direction)
		//,  m_own(true)
	{}

	/**
	 *  @brief  evZs
	 *
	 *   true ߂ĂB
	 *  eɂ鐶 @c result() ŎQƂ邱ƂłB
	 */
	bool MGProject::calculate(){
		if(!m_objective || !m_subjective || m_objective == m_subjective){
			return false;
		}
		// 悭킩Ȃ...
		if(m_direction.is_zero_vector() && !m_direction.is_null()){
			return false;
		}
		m_result.clear();

		// C++ ̋ȏIɂ̓_ȎƂudynamic_cast switchvB
		// MGObject ̔hNXlԂȂ̂łō\Ȃ낤
		if(const MGFSurface* surf = dynamic_cast<const MGFSurface*>(m_objective)){
			// surf ɓe
			if(const MGPoint* point = dynamic_cast<const MGPoint*>(m_subjective)){
				return calc_sp(surf, point);
			}else if(const MGCurve* curve = dynamic_cast<const MGCurve*>(m_subjective)){
				return calc_sc(surf, curve);
			}
		}else if(const MGShell* shell = dynamic_cast<const MGShell*>(m_objective)){
			// VFɓe
			if(const MGPoint* point = dynamic_cast<const MGPoint*>(m_subjective)){
				return calc_hp(shell, point);
			}else if(const MGCurve* curve = dynamic_cast<const MGCurve*>(m_subjective)){
				return calc_hc(shell, curve);
			}
		}
		// YȂ
		return false;
	}

	// VFɋȐ𓊉e
	bool MGProject::calc_hc(
		const MGShell* shell,
		const MGCurve* curve
		){
		MGHHisects res;
		shell->project(*curve, res, m_direction);
		if(res.empty()){
			return false;
		}
		// ƂŃ[hJ[uo...
		MGHHisects::iterator first = res.begin(), last = res.end();
		for(; first != last; ++first){
			MGHHisect& is = isectCast<MGHHisect>(first);
			m_result.emplace_back(is.release_line());
		}
		return true;
	}

	// ȖʂɋȐ𓊉e
	bool MGProject::calc_sc(
		const MGFSurface* surf,
		const MGCurve*    curve
		){
		std::vector<UniqueCurve> curves;
		surf->project(*curve, curves, m_direction);
		if(curves.empty()){
			return false;
		}
		for(auto& curve: curves)
			m_result.emplace_back(curve.release());
		return true;
	}

	// VFɓ_𓊉e
	bool MGProject::calc_hp(
		const MGShell* shell,
		const MGPoint* point
		){
		if(m_direction.is_null()){
			// ʒ (perps)
			std::vector<MGFPoint> res = shell->perps(point->position());
			if(res.empty()){
				return false;
			}
			std::vector<MGFPoint>::iterator first = res.begin(), last = res.end();
			for(; first != last; ++first){
				m_result.emplace_back(new MGPoint(first->eval()));
			}
			return true;
		}else{
			// xNg (isect)
			MGStraight line(MGSTRAIGHT_UNLIMIT, m_direction, point->position());
			MGCFisects res = shell->isect(line);
			if(res.empty()){
				return false;
			}
			// Ƃœ_
			MGCFisects::iterator  first = res.begin(), last = res.end();
			for(; first != last; ++first){
				MGCFisect& cf = isectCast<MGCFisect>(first);
				m_result.emplace_back(new MGPoint(cf.point()));
			}
			return true;
		}
	}

	// Ȗʂɓ_𓊉e鏈
	bool MGProject::calc_sp(
		const MGFSurface* surf,
		const MGPoint*    point
		){
		// ʒxNgeŏقȂ
		if(m_direction.is_null()){
			// ʒ (perps)
			MGPosition_list ls = surf->perps(point->position());
			if(ls.empty()){
				return false;
			}
			// Ƃœ_
			MGPosition_list::iterator first = ls.begin(), last = ls.end();
			for(; first != last; ++first){
				m_result.emplace_back(new MGPoint(surf->eval(*first)));
			}
			return true;
		}else{
			// xNg (isect)
			MGStraight line(MGSTRAIGHT_UNLIMIT, m_direction, point->position());
			MGCSisects ls = surf->isectFS(line);
			if(ls.empty()){
				return false;
			}
			// Ƃœ_
			MGCSisects::iterator first = ls.begin(), last = ls.end();
			for(; first != last; ++first){
				MGCSisect& csi = isectCast<MGCSisect>(first);
				m_result.emplace_back(new MGPoint(csi.point()));
			}
			return true;
		}
	}

} // namespace mgcalc
