/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// mgcalc_ellipse.cpp
#include "stdafx.h"
#include "Calc/ellipse.h"
#include "mg/Ellipse.h"
#include "mg/Plane.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

namespace mgcalc{
	namespace{
		const MGInterval range_0_2pi(0., mgDBLPAI);
	}
	
	// œ_ƕƏI_^ĕ𐶐
	std::unique_ptr<MGEllipse> create_ellipse(
		const MGPosition& F0,
		const MGPosition& F1,
		const MGPosition& P
		){
		if(F0 == F1 || P.is_collinear(F0, F1)){
			return std::unique_ptr<MGEllipse>(nullptr);
		}
		// ȉ~̒S2œ_Ԃ̒_
		const MGPosition& origin = (F0 + F1) * .5;
		// ̎ a   F0-P  F1-P ̘̒a̔Ƃ
		double a = (F0.distance(P) + F1.distance(P)) *.5;
		// ̎ L  2œ_Ԃ̋̔
		double L = F0.distance(origin);

		// major axis vZ
		const MGVector major = a * (F1 - origin) / L;
		ASSERT(MGAEqual(major.len(), a));

		// major axis ]邱Ƃ minor axis ̌vZ
		MGTransf trans;
		MGVector normal = MGPlane(F0, F1, P).normal();
		trans.set_rotate_3D(normal, mgHALFPAI, origin);
		MGPosition tmp(origin + major);
		tmp *= trans;
		
		MGVector minor = tmp - origin;
		// 𒲐
		minor /= minor.len();
		minor *= sqrt(abs(a * a - L * L));

		// ȉ~𐶐ďI
		return std::unique_ptr<MGEllipse>(new MGEllipse(origin, major, minor, range_0_2pi));
	}

	// `ɓڂȉ~𐶐
	std::unique_ptr<MGEllipse> create_ellipse(
		const MGPlane&    plane,
		const MGPosition& corner1,
		const MGPosition& corner2
		){
		// 1. plane @Ɏグ
		MGPlane pl(plane);
		pl += (corner1 - pl.center()).project(pl.normal());

		// 2. corner2 ̕ʂɖʒe
		MGPosition corner2t = pl.eval(pl.closest(corner2));

		// 3.MGEllipse RXgN^pđȉ~𐶐
		MGPosition org = (corner1 + corner2t) * .5;
		MGVector diag  = corner2t - corner1;
		MGVector u = diag.project(pl.u_deriv()) * .5;
		if(u.is_zero_vector()){
			return std::unique_ptr<MGEllipse>(nullptr);
		}
		MGVector v = diag.project(pl.v_deriv()) * .5;
		if(v.is_zero_vector()){
			return std::unique_ptr<MGEllipse>(nullptr);
		}
		return std::unique_ptr<MGEllipse>(new MGEllipse(org, u, v, range_0_2pi));
	}
} // namespace mgcalc
