/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// mgcalc.h
// declaraion for miscellaneous functions, structures, and classes
#if !defined( __MGCALC_H__)
#define __MGCALC_H__

#include "mg/PickObject.h"
#include "mg/Gel.h"
#include "mg/AbstractGels.h"
#include "mg/Interval.h"
#include "mg/Point.h"
#include "mg/BPointSeq.h"
#include "mgGL/SysGL.h"
#include "mg/Object.h"
#include "mg/Curve.h"

class MGCurve;
class MGInterval;
class MGPosition;
class MGVector;

namespace mgcalc{

	struct MGDrawObject{
		mgSysGL& m_sgl;
		bool m_bShowIsoCurve;
		int m_nDensity; ///< MGObject::drawWire's line_density

		MGDrawObject(mgSysGL& sgl, bool bShowIsoCurve, int nDensity)
			 : m_sgl(sgl),m_bShowIsoCurve(bShowIsoCurve),m_nDensity(nDensity){}

		void operator()(const MGObject* obj)const{
			obj->drawWire(m_sgl, m_bShowIsoCurve ? m_nDensity : 0);
		}
		void operator()(const UniqueObject& obj)const {
			obj->drawWire(m_sgl, m_bShowIsoCurve ? m_nDensity : 0);
		}
		void operator()(const UniqueCurve& obj)const {
			obj->drawWire(m_sgl, m_bShowIsoCurve ? m_nDensity : 0);
		}

		void operator()(const MGPickObject* po)const{
			po->top_object()->drawWire(m_sgl, m_bShowIsoCurve ? m_nDensity : 0);
		}
	};

	/// AvP[VݒɃt@N^[쐬B
	MGDrawObject CreateDrawFunctor(mgSysGL& sgl);

} // namespace mgcalc

#endif // __MGCALC_H__
