/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
// mgcalc.cpp
// declaraion for miscellaneous functions, structures, and classes
#include "stdafx.h"

#include "Calc/mgcalc.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace mgcalc{
	/// AvP[VݒɃt@N^[쐬B
	MGDrawObject CreateDrawFunctor(mgSysGL& sgl){
		UserPreference& pref = UserPreference::getInstance();

		const bool bShowIsoCurve = pref.GetBoolValue(upv_IsoCurve_Show);
		const int nDensity = pref.GetIntValue(upv_IsoCurve_Density);

		return MGDrawObject(sgl, bShowIsoCurve, nDensity);
	}
} // mgcalc
