/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
#if !defined(__MGCALC_LINE_H__)
#define __MGCALC_LINE_H__

#include <algorithm>
#include <utility>
#include <vector>
#include "mg/LBRep.h"

class MGCurve;
class MGPosition;
class MGStraight;
class MGVector;

namespace mgcalc{
	/**
	 *  @brief  𐶐
	 *  @param  ref       QƓ_
	 *  @param  end       I_
	 *  @param  bothside  @a ref ̒_Ƃ݂Ȃǂ
	 *
	 *
	 *  @a bothside  true ̂Ƃɂ́A钼
	 *  n_ 2 * @a end - @a ref, I_ end ɎԂB
	 *  false ̂Ƃɂ́A@a ref n_A@a end I_ɎԂB
	 */
	std::unique_ptr<MGCurve> create_line(
		const MGPosition& ref,
		const MGPosition& end,
		bool              bothside
		);

	/**
	 *  @brief  Ȑ̒[_ɂ钼I𐶐
	 *  @param  curve     Ȑ
	 *  @param  param     Ȑ̃p[^
	 *  @param  hint      ̏I_t߂̓_
	 *  @param  bothside  [_𐶐̒_Ƃ邩n_Ƃ邩
	 *
	 *  Ȑ̒[_ɂڐɂ𐶐B
	 *  [_̑I @a param n_AI_̂ǂ炩ɋ߂ɂČ܂B
	 *  
	 *  @a param  @a curve ̒`ɂȂƂAsB
	 *  @a hint  @a param ɂČ܂ @a curve ̒[_ƈvƂAsB
	 */
	std::unique_ptr<MGCurve> create_line_by_extension(
		const MGCurve&    curve,
		double            param,
		const MGPosition& hint,
		bool              bothside
		);

	/**
	 *  @brief  Ȑ̐𐶐
	 *  @param  curve  Ȑ
	 *  @param  pos    ȐO̓_
	 *  @param  bothside  @a pos ̒_(true)n_(false)
	 *
	 *  @a pos  @a curve ̏ɏĂƂÅ֐͎sB
	 */
	std::unique_ptr<MGCurve> create_perp_line(
		const MGCurve&    curve,
		const MGPosition& pos,
		bool              bothside
		);

	/**
	 *  @brief  Ȑ̐Ɛ̑ɂڐԂ
	 *  @param  curve     Ȑ
	 *  @param  end       ȐO̓_
	 *  @param  bothside  ̑̒_(true)n_(false)
	 *
	 *  @a end  @a curve ̏ɏĂƂÅ֐͎sB
	 *  ߂l̃yA first Asecond ڐłB
	 *
	 */
	std::pair<MGCurve*, MGCurve*> create_perp_line_ex(
		const MGCurve&    curve,
		const MGPosition& end,
		bool              bothside
		);

	/**
	 *  @brief  ~ɊOڂ鐳 N p`𐶐
	 *  @param  center  ~̒S
	 *  @param  normal  ~̏镽ʂ̖@
	 *  @param  N       p`
	 *  @param  mid     V[0]  V[N-1] ̒_
	 */
	std::unique_ptr<MGCurve> create_polygon_cir(
		const MGPosition& center,
		const MGVector&   normal,
		int               N,
		const MGPosition& mid
		);

	/**
	 *  @brief  ЂƂ̕ӂw肵Đ N p`𐶐
	 *  @param  edge0   
	 *  @param  normal  p`̏镽ʂ̖@
	 *  @param  N       p`
	 */
	std::unique_ptr<MGCurve> create_polygon_edge(
		const MGStraight& edge0,
		const MGVector&   normal,
		int               N
		);

	/**
	 *  @brief  ~ɓڂ鐳 N p`𐶐
	 *  @param  center  ~̒S
	 *  @param  normal  ~̏镽ʂ̖@
	 *  @param  N       p`
	 *  @param  V0      p`̍ŏ̒_
	 */
	std::unique_ptr<MGLBRep> create_polygon_ins(
		const MGPosition& center,
		const MGVector&   normal,
		int               N,
		const MGPosition& V0
		);

	/**
	 *  @brief  ^p`𐶐
	 *  @param  center     ~̒S
	 *  @param  normal     ~̏镽ʂ̖@
	 *  @param  N          p`
	 *  @param  V0         p`̍ŏ̒_
	 *  @param  radius2nd  ЂƂ̑p`̏~̔a
	 *
	 *  ܂ (2*N) p`B
	 */
	std::unique_ptr<MGLBRep> create_polygon_star(
		const MGPosition& center,
		const MGVector&   normal,
		int               N,
		const MGPosition& V0,
		double            radius2nd
		);

	/**
	 *  @brief  |C(܂)𐶐
	 *  @param  pos  ʉߓ_̃Xg
	 */
	std::unique_ptr<MGLBRep> create_polyline(const std::vector<MGPosition>& pos);
	
	/**
	 *  @brief same as create_polyline except that create_closed_polyline adds the
	 *  additional line segment from pos[n-1] to pos[0].
	*/
	std::unique_ptr<MGLBRep> create_closed_polyline(const std::vector<MGPosition>& pos);

	/**
	 *  @brief  Ȑ̐ڐ𖳌ƂĐ
	 *  @param  curve  Ȑ
	 *  @param  param  Ȑ̃p[^
	 *
	 *  @a param  @a curve ̒`O̒lłƂAsB
	 *
	 *  @note  ƂĂAۂɂ̓p[^
	 *  傫Ă邾ŁAꎞ`pɎg߂̂̂łB
	 */
	std::unique_ptr<MGCurve> create_tangent_line(
		const MGCurve& curve,
		double         param
		);

	/**
	 *  @brief  Ȑ̐ڐAI_ɋ߂_w肵Đ
	 *  @param  curve  Ȑ
	 *  @param  param  Ȑ̃p[^
	 *  @param  hint   ȐɂȂ_
	 *  @parab  bothside  @a param ɂ__n_
	 *
	 *  @param ɂڐ𐶐A@a hint 𐳎ˉeĐؒfB
	 */
	std::unique_ptr<MGCurve> create_tangent_line(
		const MGCurve&    curve,
		double            param,
		const MGPosition& hint,
		bool              bothside
		);

	/**
	 *  @brief  ^ꂽ4_ʉ߂|C𐶐B
	 *  @param  A  ʒu
	 *  @param  B  ʒu
	 *  @param  C  ʒu
	 *  @param  D  ʒu
	 *
	 *  ֐ 'rectangular' Ƃ邪Aʂɒ`łȂĂ悢B
	 */
	std::unique_ptr<MGLBRep> rectangular_line(
		const MGPosition& A,
		const MGPosition& B,
		const MGPosition& C,
		const MGPosition& D 
		);
	
} // namespace mgcalc

#endif // __MGCALC_LINE_H__
