/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#pragma once

#include "mg/Group.h"

namespace groupfunc
{
	/// MGGelPosition ƂNXɑ݂邪Ał͗płȂB
	struct GelLocation
	{
		MGGroup::iterator pos;
		MGGroup* group;

		GelLocation(MGGroup::iterator p, MGGroup* g)
			 : pos(p), group(g)
		{
		}
	};

	/// ėp Group c[TASYB[DB
	template <typename F>
	GelLocation SearchGroup(MGGroup& g, F func)
	{
		MGGroup::iterator first = g.begin(), last = g.end();
		for(; first != last; ++first){
			MGGel* node = first->get();
			MGGroup* g2 = dynamic_cast<MGGroup*>(node);
			if(g2){
				return SearchGroup(*g2, func);
			}else if(func(node)){
				return GelLocation(first, &g);
			}
		}
		return GelLocation(g.end(), 0);
	}

	/// ėp Group c[SASYB[DB
	template <typename F>
	void WalkGroup(MGGroup& g, F func)
	{
		MGGroup::iterator first = g.begin(), last = g.end();
		for(; first != last; ++first){
			MGGel* node = first->get();
			MGGroup* g2 = dynamic_cast<MGGroup*>(node);
			if(g2){
				WalkGroup(*g2, func);
			}else{
				func(node);
			}
		}
	}
}
