/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */

/** 
 *  @file evalcs.h
 *  @brief Classes for 'Deviation between a curve and a surfce' 
 */
#if !defined(__EVALCS_H__)
#define __EVALCS_H__

#include <iosfwd>  // for std::ostream
#include <memory> // for std::unique_ptr
#include "mg/Position.h"

class MGCurve;
class MGFSurface;

namespace mgcalc{

	/** 
	 *  @brief  _NX
	 *
	 *  ȐƋȖʂ̌vʒuێNXłB
	 */
	class MGEvalCSDevInfo{
	private:
		/**
		 *  @brief  kIuWFNg𐶐
		 */
		MGEvalCSDevInfo();

		/**
		 *  @brief  ׂẴp[^^ăIuWFNg𐶐
		 *  @param  t  Ȑ̃p[^
		 *  @param  u  Ȗʏ̃p[^ u 
		 *  @param  v  Ȗʏ̃p[^ v 
		 */
		MGEvalCSDevInfo(
			double t,
			double u,
			double v
			);

		/**
		 *  @brief  ׂẴp[^^ăIuWFNg𐶐
		 *  @param  t   Ȑ̃p[^
		 *  @param  uv  Ȗʏ̃p[^
		 */
		MGEvalCSDevInfo(
			double t,
			const MGPosition& uv
			);

	public:
		/**
		 *  @brief  n_ɂȐƋȖʂ̗Ԃ
		 */
		double distance() const;

		/**
		 *  @brief  ƈʒuvZăoɃZbg
		 *  @param  curve   ]邽߂̋Ȑ
		 *  @param  surf    ]邽߂̋Ȗ
		 */
		void evaluate(const MGCurve& curve, const MGFSurface& surf);

		/**
		 *  @brief  ǂ
		 */
		bool is_distance_null() const{ return m_null_distance;}
		
		/**
		 *  @brief  p[^ǂ
		 */
		bool is_param_null() const{ return m_null_param;}
		
		/**
		 *  @brief  ʒu񂪖ǂ
		 */
		bool is_position_null() const{ return m_null_pos;}

		/**
		 *  @brief  Ȑ̓_ɂp[^Ԃ
		 */
		double param_curve() const;

		/**
		 *  @brief  Ȗʏ̓_ɂp[^Ԃ
		 */
		MGPosition* param_surf() const;

		//@{
		/**
		 *  @brief  p[^ɑΉʒuԂ
		 */
		const MGPosition& position_curve() const;
		const MGPosition& position_surf() const;
		//@}

	private:
		/**
		 *  @brief  ̃IuWFNg𖳌
		 */
		void set_null();

		//@{
		/**
		 *  @brief  ȐƋȖʂ̃p[^ݒ肷
		 */
		void set_param(double t, const MGPosition& uv);
		void set_param(double t, double u, double v);
		//@}

	private:
		/// Ȑ̓_ƋȖʏ̓_Ƃ̋
		double m_distance;

		/// Ȑ̓_ɂp[^
		double m_t;

		/// Ȗʏ̓_ɂp[^
		double m_u;

		/// Ȗʏ̓_ɂp[^
		double m_v;

		/// Ȑ̓_̐EW
		MGPosition m_pos_curve;

		/// Ȗʏ̓_̐EW
		MGPosition m_pos_surf;

		//@{
		/// etO
		mutable bool m_null_distance : 1;
		mutable bool m_null_param    : 1;
		mutable bool m_null_pos      : 1;
		//@}

		friend class MGEvalCSInfoGroup;
		friend std::ostream& operator<<(std::ostream&, const MGEvalCSDevInfo&);
	};

	/**
	 *  @brief  ]NX
	 *
	 *  ȐƋȖʂ̋Iȗ]NXłB
	 *  ]ʒuf[^ۑB
	 */
	class MGEvalCSInfoGroup{
	public:
		using MYELM=std::unique_ptr<MGEvalCSDevInfo>;
		using MYLST=std::list<MYELM>;

		typedef MYLST::iterator       iterator;
		typedef MYLST::const_iterator const_iterator;

	private:
		const MGCurve*                 m_curve; ///< ]̑ΏۂƂȂȐ
		const MGFSurface*              m_surf;  ///< ]̑ΏۂƂȂȖ
		MYLST               m_info;  ///< ]f[^

	public:
		/**		 *  @brief  kIuWFNg𐶐B */
		MGEvalCSInfoGroup();

		/**
		 *  @brief  IuWFNg𐶐B
		 *  @param  curve  ]Ȑ
		 *  @param  surf   ]Ȗ
		 *
		 *  e|C^̏L͈ϏȂBȂ킿WρB
		 */
		MGEvalCSInfoGroup(const MGCurve* curve, const MGFSurface* surf);

		iterator       begin(){ return m_info.begin();}
		const_iterator begin() const{ return m_info.begin();}

		/**		 *  @brief  ȐԂ		 */
		const MGCurve* curve() const;

		iterator       end(){ return m_info.end();}
		const_iterator end() const{ return m_info.end();}

		/**		 *  @brief  ]ςǂԂ		 */
		bool done() const{ return !m_info.empty();}

		/**		 *  @brief  Ȑ̍וAvs
		 *  @param  maxdev   Ƃ݂ȂȂ̏lB
		 *  @param  div      mbgԂ̕B		 */
		void evaluate(double maxdev, int div);

		/**		 *  @brief  ̃IuWFNgLǂ		 */
		bool is_null() const;

		/**		 *  @brief  ]Ȑݒ肷
		 *  @oaram  ]Ȑ		 */
		void set_curve(const MGCurve* curve);

		/**		 *  @brief  ̃IuWFNg𖳌ɂ		 */
		void set_null();

		/**		 *  @brief  ]ɎgȖʂݒ肷
		*  @param  ]Ȗ		 */
		void set_surf(const MGFSurface* surf);

		/**		 *  @brief  ȖʂԂ		 */
		const MGFSurface* surf() const;
		

		// ͎Ȃ
		MGEvalCSInfoGroup(const MGEvalCSInfoGroup& other)=delete;
		MGEvalCSInfoGroup& operator=(const MGEvalCSInfoGroup& other) = delete;

		friend std::ostream& operator<<(std::ostream&, const MGEvalCSInfoGroup&);
	};
	
} // namespace mgcalc

#endif // __EVALCS_H__
