/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 *  @file curve.h
 */
#if !defined(__MGCALC_CURVE_H__)
#define __MGCALC_CURVE_H__

class MGCurve;
class MGFSurface;
class MGLBRep;
class MGLBRepEndC;
class MGLoop;
class MGPlane;
class MGPosition;
class MGRLBRep;
class MGSSisects;
class MGStraight;
class MGVector;

namespace mgcalc{

	/**
	 *  @brief  2Ȑ̒[_ԂԋȐuhɂĐB
	 *          curve1parameter t1ɋ߂[_curve2parameter t2ɋ߂[_
	 *  @param  curve1  start point side
	 *  @param  curve2  end point side
	 *  @param  t1      // parameter of curve1 that is near to the blend point
	 *  @param  t2      // parameter of curve2 that is near the end point
	 *  @param  r1      // tangent magnitude at the curve1 point
	 *  @param  r2      // tangent magnitude at the curve2 point
	 */
	std::unique_ptr<MGCurve> blend(
		const MGCurve& curve1, 
		const MGCurve& curve2, 
		double t1,   // parameter of curve1 that is near to the blend point
		double t2,   // parameter of curve2 that is near the end point
		double r1,   // tangent magnitude at the curve1 point
		double r2    // tangent magnitude at the curve2 point
	);

	/**
	 *  @brief  2Ȑ3
	 *  @param  curve1  Ȑ1
	 *  @param  curve2  Ȑ2
	 *
	 *  ǂ炩̋ȐʋȐł͂ȂƂAXC[vłȂߎsB
	 */
	MGSSisects compose_3D(const MGCurve& curve1, const MGCurve& curve2);

	/**
	 *  @brief  Ȑ[_Őڑ
	 *  @param  curve1  Ȑ1
	 *  @param  curve2  Ȑ2
	 *
	 *  composite curve ͋ɗ͕ԂȂ悤ɂĂB
	 */
	std::unique_ptr<MGCurve> connect(const MGCurve& curve1, const MGCurve& curve2);

	/**
	 *  @brief  Ȑ|Cɕϊ
	 *  @param  curve  Ro[gȐ
	 *  @param  azero  pxe덷
	 *  @param  lzero  e덷
	 */
	std::unique_ptr<MGCurve> convert_to_polyline(
		const MGCurve& curve,
		double         azero,
		double         lzero
		);

	/**
	 *  @brief  [ṽ[hJ[uIuWFNg
	 *  @param  loop   face  [v
	 */
	std::unique_ptr<MGCurve> create_curve(const MGLoop& loop);

	/**
	 *  @brief  _^ċȐ𐶐
	 *  @param  cv      _
	 *  @param  degree  
	 *  @param  close   Ȑɂ邩ǂ, close=true͂ꂽƂI_n_
	 *  @param  sharp   close == true ̂ƂAȐ̒[_点Ă悢B
	 *                  vɓIɂ͊JȐɂȂB
	 *  B
	 */
	std::unique_ptr<MGCurve> create_curve_from_cv(
		const std::vector<MGPosition>& cv,
		int                            degree,
		bool                           close,
		bool                           sharp = false
		);

	// LBRep 쐬ۂ̃mbgxNg̑ΉwpB
	// Note: uniform ͒񋟂ȂB
	enum KnotType
	{
		CHORD, ///< 0: 
		CHORD_SQRT ///< 1: ̕
	};

	/**
	 *  @brief Extends a curve.
	 *  @param  curve   original curve
	 *  @param  param   parameter on curve
	 *  @param  length  length of chord
	 *  @param  dk      curvature variation
	 */
	MGCurve* extend(
		const MGCurve& curve,
		double         param,
		double         length,
		double         dk
		);

	/**
	 *  @brief  Ȑ̈̒[_璼
	 *  @param  curve       ȐIuWFNg
	 *  @param  hint_param  Ȑp[^
	 *
	 *  @a hint_param `̎n_ɋ߂
	 *  n_Lт钼ԂBłȂΏI_
	 *  Lт钼ԂB
	 */
	MGStraight* extension(
		const MGCurve& curve,
		double         hint_param
		);

	/**
	 *  @brief  ȐLǂ𔻒肷B
	 *  @param  curve  eXgȐ
	 *
	 *  curve.param_range() 邾B
	 */
	bool is_finite(const MGCurve& curve);

	/**
	 *  @brief  Returns whether curve is Jordan-curve or not.
	 *  @param  curve  eXgȐ
	 *
	 *  Jordan curve is defined as follows:
	 *  - curve is closed
	 *  - is C2 continuous
	 *  - is planar
	 *  - and does not intersect itself.
	 */
	bool is_jordan(const MGCurve& curve);

	/**
	 *  @brief ȐȌĂ邩ǂ
	 *  @param  curve  ȐIuWFNg
	 *
	 *  Returns whether curve intersects itself or not.
	 *
	 *  @note  ̊֐͂܂ĂȂB
	 */
	bool is_self_isect(const MGCurve& curve);
	
} // namespace mgcalc

#endif // __MGCALC_CURVE_H__
