/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
/**
 *  @file conic.h
 */
#if !defined(__MGCALC_CONIC_H__)
#define __MGCALC_CONIC_H__

class MGCurve;
class MGPosition;
class MGVector;

namespace mgcalc{
	/**
	 *  @brief  ~Ȑ𐶐
	 *  @param  start  ~Ȑ̎n_
	 *  @param  end    ~Ȑ̏I_
	 *  @param  apex   n_ɂڐƏI_ɂڐ̌_
	 *  @param  rho    w / (1 + w), where w is the weight of control point ref.
	 *
	 *  @a start, @a apex, @a end 𒸓_ƂOp`̖ʐς 0 ȂΎsB
	 *  @a rho ̒l 0 ̂ƂsB
	 */
	std::unique_ptr<MGCurve> create_conic_curve(
		const MGPosition& start,
		const MGPosition& end,
		const MGPosition& apex,
		double            rho
		);

	/**
	 *  @brief  ~Ȑ𐶐
	 *  @param  start    ~Ȑ̎n_
	 *  @param  end      ~Ȑ̏I_
	 *  @param  apex     n_ɂڐƏI_ɂڐ̌_
	 *  @param  through  ʉߓ_
	 *
	 *  @a start, @a apex, @a end 𒸓_ƂOp`ʐςĂȂ΂ȂȂB
	 *  @a pos ͂̎Op`ɑ݂ȂΎsB
	 *  @a pos  @a start  @a end ɈvĂꍇ͎sB
	 */
	std::unique_ptr<MGCurve> create_conic_curve(
		const MGPosition& start,
		const MGPosition& end,
		const MGPosition& apex,
		const MGPosition& through
		);

	/**
	 *  @brief  _ƕƏI_^ĕ𐶐
	 *  @param  vertex  ̒_
	 *  @param  direction  _œ_ւ̌
	 *  @param  end  Ȑ̏I_w肷
	 *  @param  halfside  ŕƂA@a end ̂Ȃق̂Ă邩ǂ
	 *
	 *  @a end  @a vertex  @a direcion ɂƂsB
	 *  @a direction  xNĝƂsB
	 */
	std::unique_ptr<MGCurve> create_parabola(
		const MGPosition& vertex,
		const MGVector&   direction,
		const MGPosition& end,
		bool              halfside = false
		);

	/**
	 *  @brief  _Əœ_ƃ}EXJ[\^ĕ𐶐
	 *  @param  vertex  ̒_
	 *  @param  focus   ̏œ_
	 *  @param  cursor  ̎ɂȂ_
	 *  @param  halfside  ŕʂ𕪊ƂA@a cursor ̂Ȃق̂Ă邩ǂ
	 *
	 *  @a vertex  @a focus vĂƂs
	 *  @a cursor  ̎ɂƂs
	 */
	std::unique_ptr<MGCurve> create_parabola(
		const MGPosition& vertex,
		const MGPosition& focus,
		const MGPosition& cursor,
		bool              halfside = false
		);
	
} // namespace mgcalc

#endif // __MGCALC_CONIC_H__
