/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#include "stdafx.h"
#include "fugen.h"
#include "AboutDlg.h"
#include "GLVersion.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
,m_hFontLink(0), m_hCursorFinger(0), m_bHover(false){
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

CAboutDlg::~CAboutDlg(){
	if(m_hFontLink)
		DeleteObject(m_hFontLink);
	if(m_hCursorFinger)
		DestroyCursor(m_hCursorFinger);
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

// Retrieves a cursor resource from Windows.
HCURSOR CAboutDlg::GetFingerCursor() const
{
	HCURSOR hCursor=0;
	TCHAR strWinDir[MAX_PATH + 12] = {0};

	// Retrieve the path of the Windows(R) directory.
	::GetWindowsDirectory(strWinDir, MAX_PATH);
	// Map winhlp32 module into the address space of this process.
	VERIFY(::PathAppend(strWinDir, _T("winhlp32.exe")));

	HINSTANCE hInstHelp = ::LoadLibrary(strWinDir);
	if(hInstHelp){
		// Load the handle-cursor resource from winhlp32.
		hCursor = CopyCursor(::LoadCursor(hInstHelp, MAKEINTRESOURCE(106)));
		// Unmap winhlp32.exe module from the address space of this process.
		::FreeLibrary(hInstHelp);
	}
	if(!hCursor)
		hCursor = ::LoadCursor(0, IDC_ARROW);
	return hCursor;
}

BOOL CAboutDlg::PreTranslateMessage(MSG* pMsg){
	if(m_bHover){
		m_tip.RelayEvent(pMsg);
	}
	return CDialog::PreTranslateMessage(pMsg);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
	ON_WM_CTLCOLOR()
	ON_WM_SETCURSOR()

END_MESSAGE_MAP()

HBRUSH CAboutDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT /* nCtlColor */){
	int id = pWnd->GetDlgCtrlID();
	if(id == IDC_HOMEPAGE){
		// Blue means hot text.
		pDC->SetTextColor(RGB(0x00, 0x00, 0xff));
	}
	pDC->SetBkMode(TRANSPARENT);

	return (HBRUSH)GetStockObject(WHITE_BRUSH);
}

const int ID_TOOLTIP = 1;

BOOL CAboutDlg::OnInitDialog(){
	CDialog::OnInitDialog();

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	m_hFontLink = (HFONT)SendMessage(WM_GETFONT, 0, 0);

	LOGFONT logfont;
	GetObject(m_hFontLink, sizeof(LOGFONT), &logfont);
	logfont.lfUnderline = TRUE;
	m_hFontLink = CreateFontIndirect(&logfont);
	SendDlgItemMessage(IDC_HOMEPAGE, WM_SETFONT, (WPARAM)m_hFontLink, 0);

	m_hCursorFinger = GetFingerCursor();

	m_tip.Create(this);
	CRect rect;
	GetClientRect(&rect);

	CString strCaption;
	VERIFY(strCaption.LoadString(IDS_TOOLTIP_FUGEN_WEBSITE));

	m_tip.AddTool(this, strCaption, rect, ID_TOOLTIP);

	// _CAÕo[WƃRs[CgZbg
	SetDlgItemText(IDC_STATIC_VERSION, GetVersionText());
	SetDlgItemText(IDC_STATIC_COPYRIGHT, GetCopyrightText());

	return TRUE;
}

BOOL CAboutDlg::OnSetCursor(CWnd*, UINT, UINT message){
	CPoint point;
	GetCursorPos(&point);

	CWnd* hot_text = GetDlgItem(IDC_HOMEPAGE);
	CRect rect;
	hot_text->GetWindowRect(&rect);

	if(rect.PtInRect(point)){
		// The mouse pointer hovers over the label IDC_HOMEPAGE.
		SetCursor(m_hCursorFinger);
		m_bHover = true;
		if(message == WM_LBUTTONDOWN){
			if (m_hFontLink)
				DeleteObject(m_hFontLink);
			if (m_hCursorFinger)
				DestroyCursor(m_hCursorFinger);

			// Run the web browser.
			CString lpszURL;
			hot_text->GetWindowText(lpszURL);

			// Close this dialog.
			EndDialog(0);
			//Show the Home page.
			ShellExecute(theApp.GetMainWnd()->GetSafeHwnd(), _T("open"), lpszURL, 0, 0, SW_SHOW);
		}
		return TRUE;
	}else{
		m_bHover = false;
		m_tip.Pop();
		// Normal state.
		SetCursor(LoadCursor(0, IDC_ARROW));
	}
	return FALSE;
}
