/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

#if !defined(_MGVBOLEAF__INCLUDED_)
#define _MGVBOLEAF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "StdAfx.h"
#include "mgGL/glslprogram.h"
#include "mgGL/Color.h"
#include "mgGL/VBOElement.h"

class MGPosition;
class MGBPointSeq;
class MGCurve;
class mgVBO;
class mgVBOLeafBuilder;
class mgTexture;

/** @file */
/** @addtogroup DisplayHandling
 *  @{
 */


/////////////////////////////////////////////////////////////////////////////
// mgVBOLeaf

///mgVBOɑ΂ĕ`f[^쐬̏ێ邽߂̃NX.

///mgVBOmgVBOLeafmgVBOgelementƂĕێB
///mgVBOelementƂ̂MGGroup܂MGShell̃o[f[^̕\
///ێ邽
class MG_DLL_DECLR mgVBOLeaf:public mgVBOElement{

///Maximum line width.

///Used to judge the polygon mode of the polygon if this mgVBOLeaf is a triangle.
///When polygon mode = GL_LINE, m_size=the line width.
///When polygon mode = GL_POINT, the point size=m_size-m_PolygonModePointSizeBase.
///That is, if m_size>m_PolygonModePointSizeBase, its polygon mode is GL_POINT and
///the point size=m_size-m_PolygonModePointSizeBase.
static const GLfloat m_PolygonModePointSizeBase;

private:

	mgGLSL::DrawType m_drawType;/// `惂[h mgGLSL::DrawType̒l

	GLuint m_bufferID;///<glGenBuffersłō쐬ꂽBuffer idB쐬̂Ƃ=0.
				///m_bufferIDm_vertexArrayIDBindB

	///_Ƃ(StaticłȂjlw肳Ă邩ۂ
	bool m_ColorSpecified:1, m_NormalSpecified:1, m_TextureSpecified:1;

	mutable GLuint m_vertexArrayID;///<glGenVertexArraysō쐬ꂽVertexArray.쐬̂Ƃ=0.

	///(m_primitiveMode,m_count)͊ȈՕ\(VIEWMODE==WIRE)܂͋\(VIEWMODE==HIGHLIGHT)ɗpB
	///(m_primitiveMode,m_count)glDrawArraysm_bufferIDfirst=0ŎgpB
	GLenum m_primitiveMode;///<glDrawArraysɓ͂Ƃprimitive
	unsigned m_count;///<glDrawArraysɓ͂ƂVertex̐

	mutable mgTexture* m_texture;///< Texture to apply. When m_texture.get()!=null, m_texture.use()
		///<will be invoked when draw().

	MGColor m_color;///<Static Vertex-Attributes for this VBO to apply.
		///<Color data.

	GLfloat m_size;///<Static Vertex-Attributes for this VBO to apply.
		///<Line-width, or point-size.
		///<When m_primitiveMode=GL_POINTS, m_size means point size.
		///<When m_primitiveMode=GL_LINEXXX, m_size means line width.
		///<When m_primitiveMode=GLTRIANGLEXXXX, m_size means following:
		///<  m_size<0. GL_FILL
		///<  1.<=m_size<=m_PolygonModePointSizeBase. GL_LINE and the line width=m_size.
		///<  m_PolygonModePointSizeBase<m_size GL_POINT and
		///<  the point size=(m_size-m_PolygonModePointSizeBase).

	short int m_stippleFactor;///<Line stipple factor.
		///<If m_stippleFactor=0, line Stipple is disabled.
		///<   m_stippleFactor<0, line stipple is undefined.
	GLushort m_LineStipplePattern;///<m_LineStipplePatternindicates the pattern.

	///light modem_elementsShadeɑ΂Ă̂ݗLBm_elementsɑ΂Ă͏light̓It
	int m_lightMode;///<  <0: undefined, =0:Light is disabled, >0:Light is enabled.

friend class mgVBO;

public:

mgVBOLeaf();
mgVBOLeaf(GLfloat size,MGColor& color);
mgVBOLeaf(const mgVBOLeaf& vbol);
mgVBOLeaf(const mgVBOLeafBuilder& builder);
~mgVBOLeaf();

///mgVBOElementnull(܂draw/make_display_list()ĂȂj𔻒

///mgVBOm_gelɑ΂make_display_list()ȂĂȂƂfalseԂ
///mgVBOLeafmake_display_list()ꂽƂ̂ݑ݂邽ߏtrueԂB
bool is_made(MGCL::VIEWMODE viewMode=MGCL::DONTCARE){return true;};

///Remake the display list.

///łɍ쐬ς݂łĂIɍč쐬sB
///mgVBOLeaf͍쐬ς݂̏ꍇ̂ݑ݂邽߉ȂB
void make_display_list(MGCL::VIEWMODE vmode=MGCL::DONTCARE){;};

///Draw.

///`֐draw()́Ais_made()ł΁A쐬A\B
///!is_made()(`f[^쐬ς݁jł΁Ałɍ쐬ꂽmgVBOElement̕`sB
///mgVBOLeafł͏ɍ쐬݂ł\ȂB
void draw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE);

///Redraw.

///draw()mgVBOLeaf쐬ς݁inot null)ł΍쐬sȂA
///redraw()͋Iɍč쐬s`揈ȂB
///mgVBOLeafł͏ɍ쐬݂ł\ȂB
void redraw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE){draw(viewMode);};

///Draw for the Selection.

///`֐selectionDraw()́AObjectÎ߂̕\B
///ʏdrawƂ̑F///ColorƂm_bufferIDpAsizeȊO
///attributes̏inormal, texture, color)ȂB
virtual void selectionDraw(MGCL::VIEWMODE viewMode=MGCL::DONTCARE);

///DrawTypeZbg
void setDrawType(mgGLSL::DrawType drawType){m_drawType=drawType;};
mgGLSL::DrawType getDrawType()const{return m_drawType;};

///TexturesetB
void setTexture(mgTexture* texture);

///TexturegetB
const mgTexture* getTexture()const;
mgTexture* getTexture();

///Test if a texture is binded.
bool texture_is_bound()const;

///쐬ςmgVBOLeafID̈ʒuVertex dataP̃f[^ɒuB
///0<= ID <getVerticesNumber();
void updateVertex(unsigned ID, const MGPosition& P);

///쐬ςmgVBOLeafstartID̈ʒunumVertex dataPs̃f[^
///uB 0<= startID , startID+num<=getVerticesNumber().
///Here num=Ps.size();
void updateVertices(unsigned startID, const std::vector<MGPosition>& Ps);

///쐬ςmgVBOLeafstartID̈ʒunumVertex dataPs̃f[^
///uB 0<= startID , startID+num<=getVerticesNumber().
///Here num=Ps.length();
void updateVertices(unsigned startID, const MGBPointSeq& Ps);

///쐬ςmgVBOLeafstartID̈ʒunumVertices̒_dataareãf[^
///uB 0<= startID , startID+numVertices<=getVerticesNumber().
///area̔z̒numVertices*3ƂȂ
void updateVertices(unsigned startID, unsigned numVertices, const float* area);

///Vertex̐߂
unsigned getVerticesNumber()const{return m_count;};

///Obtain display list name.

///0(null) ͂mgVBOElementmgVBOLeafłAOȂƂB
///OmgVBO
unsigned getDName()const{return 0;};

///Selectionɐݒ肷閼O߂B

///=0̂ƂAO̐ݒ菈ȂB
///0(null) ͂mgVBOElementmgVBOLeafłAOȂƂB
///OmgVBO
virtual GLuint getSelectionName()const{return 0;};

///m_primitiveMode=GL_QUAD_STRIP, GL_TRIANGLES, GL_TRIANGLE_STRIP, GL_TRIANGLE_FAN
///̂Ƃɂ̂ݗLłPolygonModeiGL_POINT, GL_LINE, GL_FILL)w肷.
///setPolygonModeĂȂmgVBOLeafGL_FILLƂB
void setPolygonMode(GLenum mode);

///Set color.
void setStaticAttribColor(const MGColor& color){
	m_color=color;
};

///Set primitive mode.
void setPrimitiveMode(GLenum primitiveMode){m_primitiveMode=primitiveMode;};

///Set light mode. mode=-1:undefined, =0:disabled, =1:enabled.
void setLightMode(int mode);

///Line stippleZbgB

///When factor=0 is input, line pattern is disabled. This means the line is solid.
///When factor<0, the stipple attribute is undefined. This means the attribute
///is defined by the environment.
///When factor<=0, pattern is unnecessary.
void setLineStipple(short int factor, GLushort pattern);

///Set line width.
void setStaticAttribLineWidth(GLfloat size);///size<=0. undefined

///Set Point size.
void setStaticAttribPointSize(GLfloat size);///size<=0. undefined

protected:
	

private:
	void execStaticAttrib(MGCL::VIEWMODE viewMode, bool selection=false);

};

/** @} */ // end of DisplayHandling group
#endif // !defined(_MGVBOLEAF__INCLUDED_)
