/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
#include "StdAfx.h"
#include "mg/Box.h"
#include "mg/Straight.h"
#include "mg/Surface.h"
#include "mg/Plane.h"
#include "mg/SPointSeq.h"
#include "mg/SBRep.h"
#include "mg/RSBRep.h"
#include "mg/Tolerance.h"

#if defined(_DEBUG)
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Implementation of surface offset.

#define POW_LOW 0.34   //ŏɃItZbg|Cg߂W(xd)
#define POW_HIGH 0.50  //ŏɃItZbg|Cg߂W(xd)
#define NUM_DIV 25     //1pb`̕zƂPOW_LOWgp悤ɂ

//ItZbg֐
//ItZbǵAm[}𐳂ƂBȗa傫ItZbg͍sȂ
//߂ĺAItZbgȖʃXgԋpBG[̂Ƃ0̋ȖʃXgԂB
//gXline_zero()gpĂB
std::vector<UniqueSurface> MGSurface::offset(
	double ofs_value,			//ItZbg
	int& error) const			//G[R[h 0: -2:ȗaȏ̃ItZbgs -3:ʐRXgN^G[
{
	//u̐܂̕ŕ
	std::vector<UniqueSurface> vecSrf, ofs_srfl, null_srf_vec;
	int div = divide_multi_knot(vecSrf);
	for(int i = 0; i < div; i++){
		UniqueSurface pofs_srf = vecSrf[i]->offset_c1(ofs_value, error);	//ItZbgs
		if(error < 0)return null_srf_vec;
		ofs_srfl.emplace_back(pofs_srf.release());
	}
	return ofs_srfl;
}

//Offset.
//distance is plus value if the direction is toward normal vector of the
//FSurface. Minus if against the normal vector.
//G[R[h 0: -1:ȗaȏ̃ItZbgs -3:ʐRXgN^G[
int MGSurface::offset_fs(
	double distance,
	std::vector<UniqueFSurface>& vecOfsFSurface	//Offset MGFSurfaces are appended.
)const{
	int error;
	std::vector<UniqueSurface> srfs=offset(distance,error);
	if(error)
		return error;

	std::move(srfs.begin(), srfs.end(), std::back_inserter(vecOfsFSurface));
	return 0;
}

//C1AȖʂ̈ItZbg֐
//ItZbǵAm[}𐳂ƂBȗa傫ItZbg͍sȂB
//߂ĺAItZbgȖʂ̃I[g|C^łBG[̂ƂkԂB
//gXline_zero()gpĂB
std::unique_ptr<MGSurface> MGSurface::offset_c1(
	double ofs_value,		//ItZbg
	int& error) const		//G[R[h 0: -1:ʂɂꂪ
 					// -2:ȗaȏ̃ItZbgs -3:ʐRXgN^G[
{
	//C0ÂƂG[
	std::unique_ptr<MGSurface> pofs_srf;
	const MGKnotVector &knotu = knot_vector_u(), &knotv = knot_vector_v();	//SBRep, RSBRep݂̂
	int startu = knotu.order() - 1, startv = knotv.order() - 1, index = 0;
	if(type() == MGSURFACE_SPLINE){	//mVîƂ̃`FbNs
		if(knotu.order() != 2){
			if(knotu.locate_multi(startu, knotu.order() - 1, index)){error = -1; return pofs_srf;}
		}else if(knotu.bdim() > 2){error = -1; return pofs_srf;}
		if(knotv.order() != 2){
			if(knotv.locate_multi(startv, knotv.order() - 1, index)){error = -1; return pofs_srf;}
		}else if(knotv.bdim() > 2){error = -1; return pofs_srf;}
	}

	//ItZbgȗaȓǂׂ
	if(!offset_check_curva(ofs_value)){error = -2; return pofs_srf;}

	//ʂ𕪊mbgxNgƃf[^|CgvZ
	MGKnotVector knotVec_u, knotVec_v;
	MGNDDArray data_point_u, data_point_v;
	offset_calc_knot_vec(knotVec_u, knotVec_v, data_point_u, data_point_v);

	//ItZbgʂ쐬
	int	ulen = knotVec_u.bdim(), vlen = knotVec_v.bdim();
	MGSPointSeq sb1(ulen, vlen, sdim());
	for(int i = 0; i < ulen; i++){
		for(int j = 0; j < vlen; j++){
			double data_u = data_point_u(i), data_v = data_point_v(j);
			MGPosition pos, ofs_pos;
			pos = eval(data_u, data_v, 0, 0);
			MGVector N(unit_normal(data_u, data_v));
			ofs_pos = pos + (N* ofs_value);
			sb1.store_at(i, j, ofs_pos);
		}
	}
	MGSBRep* ofs_sbrep=new MGSBRep;
	ofs_sbrep->setKnotVector(std::move(knotVec_u), std::move(knotVec_v));
	ofs_sbrep->buildByInterpolationWithKTV(data_point_u, data_point_v, sb1);
	ofs_sbrep->remove_knot();
	ofs_sbrep->copy_appearance(*this);
	pofs_srf.reset(ofs_sbrep);
	error = 0;
	return pofs_srf;
}

//C1AȖʂ̈ItZbg֐
//ItZbǵAm[}𐳂ƂBȗa傫ItZbg͍sȂ
//߂ĺAItZbgȖʂ̃I[g|C^łBG[̂Ƃ̓kԂB
//gXline_zero()gpĂB
std::unique_ptr<MGSurface> MGPlane::offset_c1(
	double ofs_value,				//ItZbg
	int& error) const				//G[R[h 0: -1:ʂɂꂪ
									// -2:ȗaȏ̃ItZbgs -3:ʐRXgN^G[
{
	MGPlane ofs_plane = *this + (this->normal() * ofs_value);
	std::unique_ptr<MGSurface> pofs_srf(new MGPlane(ofs_plane));
	error = 0;
	return pofs_srf;
}

//C1AȖʂ̈ItZbg֐ŎgpmbgxNgƃf[^|Cg߂֐
void MGSurface::offset_calc_knot_vec(
	MGKnotVector& knot_vec_u,			//܂umbgxNg
	MGKnotVector& knot_vec_v,			//܂vmbgxNg
	MGNDDArray& data_point_u,			//܂uf[^|Cg
	MGNDDArray& data_point_v) const		//܂vf[^|Cg
{
	int num_div = offset_div_num();		//2lɉĕ߂
	int ord_u = order_u(), ord_v = order_v();
	int knotNumU = (bdim_u() - ord_u + 1) * num_div, knotNumV = (bdim_v() - ord_v + 1) * num_div;
	if(ord_u < 4)ord_u = 4; if(ord_v < 4)ord_v = 4;
	knot_vec_u = MGKnotVector(knot_vector_u(), ord_u);
	knot_vec_v = MGKnotVector(knot_vector_v(), ord_v);
	knot_vec_u.change_knot_number(knotNumU);
	knot_vec_v.change_knot_number(knotNumV);
	data_point_u.buildByKnotVector(knot_vec_u);
	data_point_v.buildByKnotVector(knot_vec_v);
}

//ȗaƃItZbgl̔s
//error̂Ƃfalseԋp
int MGSurface::offset_check_curva(
	double ofs_value) const		//ItZbg
{
	offset_check_curva_one(ofs_value);
	MGSurface *temp_srf = this->copy_surface();
	temp_srf->exchange_uv();

	int rtn = temp_srf->offset_check_curva_one(-ofs_value);	//uvւ̂normaltɂȂ
	delete temp_srf;
	return rtn;
}

//ȗaƃItZbgl̔s(u=const̃p[^Ȑgp)
//error̂Ƃfalseԋp
int MGSurface::offset_check_curva_one(
	double ofs_value) const		//ItZbg
{
	//uXp2*orderŕp[^Ȑ̋ȗaItZbgl傫ǂׂ
	int i, j, k, l;
	for(i = order_u() - 1; i < bdim_u(); i++){
		double uspan = (knot_u(i + 1) - knot_u(i)) / (2. * order_u());
		int ndiv_u = 2 * order_u();
		if(i == bdim_u() - 1)ndiv_u++;
		for(k = 0; k < ndiv_u; k++){
			double uparam = knot_u(i) + (uspan * k);
			MGCurve* pcrv = parameter_curve(1, uparam);	//u = const̃p[^Ȑ
			for(j = order_v() - 1; j < bdim_v(); j++){
				double vspan = (pcrv->knot(j + 1) - pcrv->knot(j)) / (2. * pcrv->order());
				int ndiv_v = 2 * pcrv->order();
				if(j == bdim_v() - 1)ndiv_v++;
				for(l = 0; l < ndiv_v; l++){
					double vparam = pcrv->knot(j) + (vspan * l), curva, torsion, radius;
					MGUnit_vector T, N, B, norm;
					pcrv->Frenet_frame(vparam, T, N, B, curva, torsion);
					norm = unit_normal(uparam, vparam);
					if((N % norm) * ofs_value <= 0 || MGMZero(curva))continue;
					radius = 1. / curva;
					if((radius * radius) < (ofs_value * ofs_value)){delete pcrv; return false;}
				}
			}
			delete pcrv;
		}
	}
	return true;
}

//ItZbgTv|Cg1pb`Ƃ̕߂
//SẴpb`̕ōő̒lԂ
int MGSurface::offset_div_num() const{
	int max_div = 0;
	int bdu=bdim_u(), bdv=bdim_v();
	for(int i = order_u() - 1; i < bdu; i++){
		MGInterval itvl_u(knot_u(i), knot_u(i + 1));
		for(int j = order_v() - 1; j < bdv; j++){
			MGInterval itvl_v(knot_v(j), knot_v(j + 1));
			int div = offset_div_num_one(MGBox(itvl_u, itvl_v));
			if(div > max_div)max_div = div;
		}
	}
	return max_div;
}

//ItZbgTv|Cg1pb`Ƃ̕߂
//SẴpb`̕ōő̒lԂ
int MGPlane::offset_div_num() const
{
	return 1;
}

//ItZbgTv|Cg1pb`Ƃ̕߂
//n = sqrt(1 / tol) * sqrt((M1 + 2 *M2 + M3) / 8)͈ȏ̎ŋ܂
int MGSurface::offset_div_num_one(
	const MGBox& param_range) const{
	int orderu=order_u(), orderv=order_v();

	//calculate maximum second derivative
	int div_u = 2 * orderu, div_v = 2 * orderv;
	double span_u = fabs(param_range.high().ref(0) - param_range.low().ref(0)) / double(div_u);
	double span_v = fabs(param_range.high().ref(1) - param_range.low().ref(1)) / double(div_v);
	double start_u = param_range.low().ref(0), start_v = param_range.low().ref(1);
	double M1 = 0.0, M2 = 0.0, M3 = 0.0;	//M1: Maximum Second derivative of Suu, M2: Suv, M3: Svv
	for(int i = 0; i <= div_u; i++){
		for(int j = 0; j <= div_v; j++){
			double param_u = start_u + (span_u * i), param_v = start_v + (span_v * j);
			double d1 = eval(param_u, param_v, 2, 0).len() * span_u * span_u;	//Second derivative of Suu
			double d2 = eval(param_u, param_v, 2, 2).len() * span_v * span_v;	//Second derivative of Suv
			double d3 = eval(param_u, param_v, 0, 2).len() * span_u * span_v;	//Second derivative of Svv
			if(d1 > M1)M1 = d1;
			if(d2 > M2)M2 = d2;
			if(d3 > M3)M3 = d3;
		}
	}
	int n = int(pow((1. / MGTolerance::line_zero()), POW_HIGH) * sqrt((M1 + (2. * M2) + M3) / 8.));
	if(n > NUM_DIV)n = int(pow((1. / MGTolerance::line_zero()), POW_LOW) * sqrt((M1 + (2. * M2) + M3) / 8.));
	if(n < 2*orderu) n=2*orderu;
	if(n < 2*orderv) n=2*orderv;
	return n;
}

//u܂vɐ܂(}`mbg)Ƃʂ𕪊
//߂ĺAԋp
int MGSBRep::divide_multi_knot(
	std::vector<UniqueSurface>& srfl	///Divided objects are appended.
) const {
	//u̐܂̕ŕ
	std::vector<UniqueSBRep> srf_u;
	int udiv = divide_multi_knot_u(srf_u), num = 0;
	for(int i = 0; i < udiv; i++){
		//v̐܂ŕ
		std::vector<UniqueSBRep> srf_v;
		num += srf_u[i]->divide_multi_knot_v(srf_v);
		std::move(srf_v.begin(), srf_v.end(), std::back_inserter(srfl));
	}
	return num;
}

//uɐ܂(}`mbg)Ƃʂ𕪊
//߂ĺAԋp
int MGSBRep::divide_multi_knot_u(
	std::vector<UniqueSBRep>& srfl) const		//ȖʃXg
{
	int start_index = 0, index = 0, count = 0, multi = 0, bdim = 0, order = 0;
	MGInterval intv = param_range().ref(1);
	const MGKnotVector &knot_vector = knot_vector_u();
	start_index = order_u() - 1;
	bdim = bdim_u();
	order = order_u();
	do{		//u,vɐ܂(C0A)Ƃʂ𕪊
		if(order == 2){		//I[_[2̂Ƃ̏
			index = start_index + 1; multi = 1;
		}else{
			multi = knot_vector.locate_multi(start_index, order - 1, index);
		}
		MGBox uv_range = MGBox(MGInterval(knot_u(start_index), knot_u(index)), intv);
		MGSBRep* sb=new MGSBRep;
		shrinkToParameters(uv_range, *sb);
		srfl.emplace_back(sb);
		start_index = index + multi - 1;
		count++;
	}while(index != bdim);	//dxȂI
	return count;
}

//vɐ܂(}`mbg)Ƃʂ𕪊
//߂ĺAԋp
int MGSBRep::divide_multi_knot_v(
	std::vector<UniqueSBRep>& srfl///Divided MGRSBRep are appended.
)const{
	int start_index = 0, index = 0, count = 0, multi = 0, bdim = 0, order = 0;
	MGInterval intv = param_range().ref(0);
	const MGKnotVector &knot_vector = knot_vector_v();
	start_index = order_v() - 1;
	bdim = bdim_v();
	order = order_v();
	do{		//u,vɐ܂(C0A)Ƃʂ𕪊
		if(order == 2){		//I[_[2̂Ƃ̏
			index = start_index + 1; multi = 1;
		}else{
			multi = knot_vector.locate_multi(start_index, order - 1, index);
		}
		MGBox uv_range = MGBox(intv, MGInterval(knot_v(start_index), knot_v(index)));
		MGSBRep* sb=new MGSBRep;
		shrinkToParameters(uv_range, *sb);
		srfl.emplace_back(sb);
		start_index = index + multi - 1;
		count++;
	}while(index != bdim);	//dxȂI
	return count;
}

//u܂vɐ܂(}`mbg)Ƃʂ𕪊
//߂ĺAԋp
int MGRSBRep::divide_multi_knot(
	std::vector<UniqueSurface>& srfl	///Divided objects are appended.
) const {
	//u̐܂̕ŕ
	std::vector<UniqueRSBRep> srf_u;
	int udiv = divide_multi_knot_u(srf_u), num = 0;
	for(int i = 0; i < udiv; i++){
		//v̐܂ŕ
		std::vector<UniqueRSBRep> srf_v;
		num += srf_u[i]->divide_multi_knot_v(srf_v);
		std::move(srf_v.begin(), srf_v.end(), std::back_inserter(srfl));
	}
	return num;
}

//uɐ܂(}`mbg)Ƃʂ𕪊
//߂ĺAԋp
int MGRSBRep::divide_multi_knot_u(
	std::vector<UniqueRSBRep>& srfl///Divided MGRSBRep are appended.
)const{
	MGInterval intv = param_range().ref(1);
	const MGKnotVector &knot_vector = knot_vector_u();
	int start_index = order_u() - 1, index = 0, count = 0, multi = 0, bdim = bdim_u(), order = order_u();
	do{		//uɐ܂(}`mbg)Ƃʂ𕪊
		if(order == 2){		//I[_[2̂Ƃ̏
			index = start_index + 1; multi = 1;
		}else{
			multi = knot_vector.locate_multi(start_index, order - 1, index);
		}
		MGBox uv_range = MGBox(MGInterval(knot_u(start_index), knot_u(index)), intv);
		MGRSBRep* rsb=new MGRSBRep;
		shrinkToParameters(uv_range, *rsb);
		srfl.emplace_back(rsb);
		start_index = index + multi - 1;
		count++;
	}while(index != bdim);	//dxȂI
	return count;
}

//vɐ܂(}`mbg)Ƃʂ𕪊
//߂ĺAԋp
int MGRSBRep::divide_multi_knot_v(
	std::vector<UniqueRSBRep>& srfl	///Divided MGRSBRep are appended.
) const{
	MGInterval intv = param_range().ref(0);
	const MGKnotVector &knot_vector = knot_vector_v();
	int start_index = order_v() - 1, index = 0, count = 0, multi = 0, bdim = bdim_v(), order = order_v();
	do{		//uɐ܂(}`mbg)Ƃʂ𕪊
		if(order == 2){		//I[_[2̂Ƃ̏
			index = start_index + 1; multi = 1;
		}else{
			multi = knot_vector.locate_multi(start_index, order - 1, index);
		}
		MGBox uv_range = MGBox(intv, MGInterval(knot_v(start_index), knot_v(index)));
		MGRSBRep* rsb=new MGRSBRep;
		shrinkToParameters(uv_range, *rsb);
		srfl.emplace_back(rsb);
		//first_index = start_index = index + multi - 1;
		start_index = index + multi - 1;
		count++;
	}while(index != bdim);	//dxȂI
	return count;
}

//u܂vɐ܂(C0A)Ƃʂ𕪊
//߂ĺAԋp
int MGSurface::divide_multi_knot(
	std::vector<UniqueSurface>& srfl	///Divided objects are appended.
) const {
	srfl.emplace_back(copy_surface());
	return 1;
}

