/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.junction;

import org.famteam.synapse.http.CookieData;
import org.famteam.synapse.http.FormData;
import org.famteam.synapse.http.RequestWrapper;
import org.famteam.synapse.http.ServerInfo;
import org.famteam.synapse.http.SessionData;
import org.famteam.synapse.junction.PageJunctionException;
import org.famteam.synapse.junction.PageJunctionTarget;
import org.famteam.synapse.junction.PageJunctionTargetException;

public abstract class PageJunction {
    protected boolean doPageJunction(RequestWrapper request_wrapper) throws PageJunctionException {
        return this.doPageJunction(request_wrapper.getFormData(), request_wrapper.getSessionData(), request_wrapper.getCookieData(), request_wrapper.getServerInfo());
    }

    public abstract boolean doPageJunction(FormData var1, SessionData var2, CookieData var3, ServerInfo var4) throws PageJunctionException;

    public PageJunctionTarget[] getPageJunctionTargets() throws PageJunctionException {
        try {
            return (PageJunctionTarget[])this.getClass().getField("PAGE_JUNCTION_TARGETS").get(this);
        }
        catch (IllegalArgumentException e) {
            throw new PageJunctionException();
        }
        catch (SecurityException e) {
            throw new PageJunctionException();
        }
        catch (IllegalAccessException e) {
            throw new PageJunctionException();
        }
        catch (NoSuchFieldException e) {
            throw new PageJunctionException();
        }
    }

    protected void setupPageJunctionTargets() throws PageJunctionException, PageJunctionTargetException {
        PageJunctionTarget[] page_junction_targets = this.getPageJunctionTargets();
        int i = 0;
        while (i < page_junction_targets.length) {
            page_junction_targets[i].compilePageJunctionPattern();
            ++i;
        }
    }

    public boolean isTarget(String request_page_name) throws PageJunctionException, PageJunctionTargetException {
        PageJunctionTarget[] page_junction_targets = this.getPageJunctionTargets();
        int i = 0;
        while (i < page_junction_targets.length) {
            if (page_junction_targets[i].isTargetPageRegex(request_page_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getPageJunctionPriority() throws PageJunctionException {
        try {
            return (Integer)this.getClass().getField("PAGE_JUNCTION_PRIORITY").get(this);
        }
        catch (IllegalArgumentException e) {
            throw new PageJunctionException();
        }
        catch (SecurityException e) {
            throw new PageJunctionException();
        }
        catch (IllegalAccessException e) {
            throw new PageJunctionException();
        }
        catch (NoSuchFieldException e) {
            throw new PageJunctionException();
        }
    }

    public boolean equals(Object arg0) {
        String this_class_name = this.getClass().getName();
        String compare_class_name = arg0.getClass().getName();
        return this_class_name.equals(compare_class_name);
    }

    public int hashCode() {
        try {
            return this.getPageJunctionTargets().length;
        }
        catch (PageJunctionException e) {
            return -1;
        }
    }
}

