/*
 * Decompiled with CFR 0.152.
 */
package org.famteam.synapse.http;

import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.famteam.synapse.http.CookieData;
import org.famteam.synapse.http.OneCookie;

public class CookieDataManager {
    public static CookieData getCookieData(HttpServletRequest request) {
        CookieData cookie_data = new CookieData();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                OneCookie one_cookie = new OneCookie();
                one_cookie.setName(cookies[i].getName());
                one_cookie.setMax_age(cookies[i].getMaxAge());
                one_cookie.setDomain(cookies[i].getDomain());
                one_cookie.setPath(cookies[i].getPath());
                one_cookie.setValue(cookies[i].getValue());
                cookie_data.addCookie(one_cookie);
                ++i;
            }
        }
        return cookie_data;
    }

    public static void setCookieData(HttpServletResponse response, CookieData cookie_data) {
        if (cookie_data != null) {
            Iterator cookie_data_iterator = cookie_data.getCookieDataIterator();
            while (cookie_data_iterator.hasNext()) {
                OneCookie now_one_cookie = (OneCookie)cookie_data_iterator.next();
                Cookie now_cookie = new Cookie(now_one_cookie.getName(), now_one_cookie.getValue());
                now_cookie.setMaxAge(now_one_cookie.getMax_age());
                if (now_one_cookie.getDomain() != null) {
                    now_cookie.setDomain(now_one_cookie.getDomain());
                }
                if (now_one_cookie.getPath() != null) {
                    now_cookie.setPath(now_one_cookie.getPath());
                }
                response.addCookie(now_cookie);
            }
        }
    }
}

