#-*- mode:perl; coding:euc-jp -*-
#$Id: func.pm,v 1.1.1.1 2007/04/18 16:16:05 kohju Exp $
#
#------------------------------------
# symbolic script ؿѥå 
#------------------------------------
package func;
use  Exporter;

@ISA= qw(Exporter);
@EXPORT=qw(sanitize1 url_check url_host domain_check concat str_length str_mb_length 
	   asc_num mb_num ismb isasc han2zen zen2han mail_check jmime_encode jmime_decode
	   toHTML changeAnchortag toPLAIN escapeHTMLf toMIME toDISP ecc toTextArea hasDirTrav pTime);


use strict;
use Jcode;
use MIME::Base64;
use CGI;
use POSIX qw(tmpnam);

use def;
use config;
use servermode;
use math;
use sp;
use log;

#ɤ餫ͭˤƤ
#Date.pmѤǤĶǤJpcDateͭˤǤޤsymbolic scripttime̿᤬ѤǤޤ
use JpcDate;
#use NoDate;


#------------------------------------
# ʸ˥롼Ȥλ../ʤɤΤܤ褦ɽäƤʤǧޤ
# 줿ʸ[-_.\/A-Za-z0-9]ʳʸõǴʸȽꤹ롣
# in  : ʸ
# out : true:Ĥ줿ɽä, false:ĤƤʤɽä
#------------------------------------
sub sanitize1
{
    my ($str) = @_;
    return $TRUE unless (defined($str)); #ƤʤȤTRUE֤

    $str=~s/[^-_.\/A-Za-z0-9]//g; # Ĥ줿ʸʳõ

    if(($str =~ /\.\.\//) || ($str=~/^\//)){
	return $FALSE;
    }else{
	return $TRUE;
    }
}

#------------------------------------
# ʸ˥롼Ȥλ../ʤɤΤܤ褦ʻ꤬äƤʤǧޤ
# in  : url
# out : true, false
#------------------------------------
sub url_check
{
    my ($str) = @_;
    return sanitize1($str);
}

#------------------------------------
# ʸ˥롼Ȥλ../ʤɤΤܤ褦ʻ꤬äƤʤǧޤ
# in  : domain
# out : true, false
#------------------------------------
sub domain_check{
  my ($dm) = @_;
  if($dm=~/^(([A-Za-z0-9]+([-A-Za-z0-9]+[A-Za-z0-9])?\.)+)([A-Za-z0-9][A-Za-z0-9]+)$/){
    return $TRUE;
  }else{
    return $FALSE;
  }
}

#------------------------------------
# urlۥȾޤ
# in  : url
# out : hostname, port
#------------------------------------
sub url_host
{
    my ($url) = @_;
    return ("","") unless(defined($url));
    $url =~ /^https?:\/\/([-a-zA-Z0-9.]+)(:*[0-9]*)\/*/;
    my $host= (defined($1))? $1: "";
    my $port= (defined($2))? $2: "";
    return ($host, $port); #hostname   $2:port
}

#------------------------------------
# ʸϢ
# in  : ʸ1,ʸ2,ʸ3...ʸn
# out : Ϣ뤵줿ʸ
# ex)(1,2,"ab",4) = 12ab4
#------------------------------------
sub concat
{
    my (@opland) = @_;
    my $sum="";
    foreach my $src (@opland){
	$sum.=$src;
    }
    return $sum;
}

#---------------------------------------
#ʸå
#---------------------------------------
#------------------------------------
# ʸå
# in  : ʸ
# out : ʸ
# ñʤʸĹ֤
# 2Хʸ2Ȥƴ롣
# ex)length("abcd") ͤ10ˤʤ
#------------------------------------
sub str_length
{
    my ($str) = @_;
    return length($str);
}
#------------------------------------
# ʸå
# in  : ʸ
# out : ʸ
# ex)str_mb_length("abcd") ͤ7ˤʤ
#------------------------------------
sub str_mb_length
{
    my ($str) = @_;

    return length($str) - &mb_num($str)/2;
}

#------------------------------------
# Ⱦʸʸå
# in  : ʸ
# out : Ⱦʸ
#------------------------------------
sub asc_num
{
    my ($str) = @_;
    return "" unless(defined($str));
    return $str =~ tr/\x20-\x7e/\x20-\x7e/;
}

#------------------------------------
# ʸʸå
# in  : ʸ
# out : ʸ*2
#------------------------------------
sub mb_num
{
    my ($str) = @_;
    return "" unless(defined($str));

    my $n = $str =~ tr/\xa1-\xfe/\xa1-\xfe/;
    return $n;
}

#------------------------------------
# Ѥ
# in  : ʸ
# out : true,false
#------------------------------------
sub ismb
{
    my ($str) = @_;
    return $FALSE unless(defined($str));

    my $n1 = mb_num($str);
    my $n2 = length($str);
    if ($n1 == $n2){
	return $TRUE;
    }else{
	return $FALSE;
    }
}

#------------------------------------
# ȾѤ
# in  : ʸ
# out : 1:OK 0:NG
#------------------------------------
sub isasc
{
    my ($str) = @_;
    return $FALSE unless(defined($str));

    my $n1 = asc_num($str);
    my $n2 = length($str);
    if ($n1 == $n2){
	return $TRUE;
    }else{
	return $FALSE;
    }
}

#------------------------------------
# Ⱦѱѿѱѿˤ
# ¾εѴޤ
# in  : ʸ
# out : ʸ
#------------------------------------
sub han2zen
{
    my ($str) = @_;
    return "" unless(defined($str));
    return Jcode->new($str)->tr('A-Za-z0-9','-ڣ--');
}

#------------------------------------
# ѱѿȾѱѿˤ
# ¾εѴޤ
# in  : ʸ
# out : Ⱦʸ
#------------------------------------
sub zen2han
{
    my ($str) = @_;
    return "" unless(defined($str));
    return Jcode->new($str)->tr('-ڣ--','A-Za-z0-9');
}


#------------------------------------
#email ᡼륢ɥ쥹Ƚꤹ
# in  : mailaddress
# out : true,false
#------------------------------------
sub mail_check
{
    my ($ad) = @_;
    return $FALSE unless(defined($ad));
    my $mail_regex =
      q{(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\} .
	q{\[\]\000-\037\x80-\xff])|"[^\\\\\x80-\xff\n\015"]*(?:\\\\[^\x80-\xff][} .
	  q{^\\\\\x80-\xff\n\015"]*)*")(?:\.(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x} .
	    q{80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff])|"[^\\\\\x80-} .
	      q{\xff\n\015"]*(?:\\\\[^\x80-\xff][^\\\\\x80-\xff\n\015"]*)*"))*@(?:[^(} .
		q{\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\0} .
		  q{00-\037\x80-\xff])|\[(?:[^\\\\\x80-\xff\n\015\[\]]|\\\\[^\x80-\xff])*} .
		    q{\])(?:\.(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,} .
		      q{;:".\\\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\\\x80-\xff\n\015\[\]]|\\\\[} .
			q{^\x80-\xff])*\]))*};


    return $FALSE if ($ad !~ /^$mail_regex$/o);
    return $TRUE;
}


#------------------------------------
# mime encode
# in  : Ѵʸ 
# out : Ѵʸ
#------------------------------------
sub jmime_encode
{
    my ($str) = @_;
    return "" unless(defined($str));
#   jcode($str)->mime_encode; ȤۤѴ롣 
    '=?ISO-2022-JP?B?'.
       encode_base64(Jcode->new($str)->iso_2022_jp,'').
       '?=';
}

#------------------------------------
# mime decode
# in  : Ѵʸ, Τʸ 
# out : Ѵʸ
#------------------------------------
sub jmime_decode
{
    my ($e_str, $rootcode) = @_;
    return "" unless(defined($e_str));

    return "" if ($e_str eq "");
    my $code = getcode($e_str);
    if(defined($code) && $code eq "ascii"){
	#ܸǤϤʤ 
	return Jcode->new($e_str)->mime_decode->h2z->euc;
    }else{
	if($rootcode){
	    return Jcode->new($e_str, $rootcode)->h2z->euc;
	}else{
	    return Jcode->new($e_str)->h2z->euc;
	}
    }
}

#------------------------------------
# HTMLѴ 
# in  : 
# out : 
#------------------------------------
sub escapeHTMLf
{
    my ($toencode) = @_;
    return "" unless(defined($toencode));
    $toencode =~ s/\&/&amp;/g;
    $toencode =~ s/\</&lt;/g;
    $toencode =~ s/\>/&gt;/g;
    $toencode =~ s/\"/&quot;/g; #"
    return $toencode;
}


#------------------------------------
# url򥢥󥫡ѹ롣
# in  : ʸ
# out : url󥫡ǰϤޤ줿ʸ
#------------------------------------
sub changeAnchortag
{
    my ($src) = @_;
    $src=~s/(http[A-Za-z0-9\%\/:\.]+)/<a href="$1">$1<\/a>/g;
    return $src;
}


#------------------------------------
# Ѵؿ html
# in  : Ѵʸ
# out : htmlѴ줿ʸ
#------------------------------------
sub toHTML
{
    my ($src) = @_;
    return "" unless(defined($src));
    if (0){
	$src = &CGI::escapeHTML($src);
    }else{
	$src = escapeHTMLf($src); 
    }
    $src =~ s/\r\n/<BR>/g;
    $src =~ s/\r/<BR>/g;
    $src =~ s/\n/<BR>/g;  #٤Ƥβԥɤ<BR>ѴƤϤ
    return $src;
}

#------------------------------------
# Ѵؿ plain
# in  : Ѵʸ
# out : plainѴ줿ʸ
#------------------------------------
sub toPLAIN
{
    my ($src) = @_;
    return "" unless(defined($src));
#    return ecc($src);
    return $src;
}


#------------------------------------
# Ѵؿ mime
# in  : Ѵʸ
# out : mimeѴ줿ʸ
#------------------------------------
sub toMIME
{
  my($src)=@_;
  return "" unless(defined($src));
  return jmime_encode($src);
}

#------------------------------------
# Ѵؿ disp
# in  : Ѵʸ,ɽե饰(0:plain, !0:HTML)
# out : dispѴ줿ʸ
#------------------------------------
sub toDISP
{
  my($src, $flag)=@_;
  return "" unless(defined($src));
  if($flag){
    return toHTML($src);
  }else{
    return toPLAIN($src);
  }
}

#------------------------------------
# Ѵؿ textarea
# in  : Ѵʸ
# out : textareaѴ줿ʸ
# toHTMLȤΰ㤤ϲԥɤ<BR>Ѵʤȡ
#------------------------------------
sub toTextArea
{
  my($src)=@_;
  return "" unless(defined($src));
  $src = escapeHTMLf($src);	# ׽\n<BR>Ѵ
  return $src;
}

#------------------------------------
# Expand Control Code ȥ륳ɽ
# in  : ʸ(\n,\r,\t,\f,\e)
# out : ȥ륳ɤᤷ
# ex) print2_ecc("test\n") ԥɤȤȽǤ졢ʸ֤
#------------------------------------
sub ecc
{
    my ($str) = @_;
    return "" unless(defined($str));
    $str =~ s/\\b/\b/g;
    $str =~ s/\\f/\f/g;
    $str =~ s/\\n/\n/g;
    $str =~ s/\\r/\r/g;
    $str =~ s/\\t/\t/g;
    $str =~ s/\\0/\0/g;
    $str =~ s/\\e/\e/g;
    $str =~ s/\\(.)/$1/g;
	# Хåå夬ˤĤʸϼʸ򤽤Τޤɽ롣
    return $str;
}

#------------------------------------
# ǥ쥯ȥȥС
# in  : ѥ̾
# out : Ĥ줿ʸΤߤǹ줿Ϥ줿ѥ̾Ǥʤϥ̥륹ȥ
#------------------------------------
sub hasDirTrav
{
    my($path) = @_;
    if(($path =~ /\.\.\//) || ($path=~/^\//)){
	return "";
    }
    return $path;
}

#------------------------------------
# pTime
# in  : 
# out : Date.pm󥹥ȡ뤵Ƥ̤֤
#------------------------------------
sub pTime
{
    return ppTime();
}

1
